/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import org.cojen.tupl.io.Utils;

public class WeakPool<B> {
    private static final VarHandle cFirstHandle;
    private static final VarHandle cLastHandle;
    private static final VarHandle cNextHandle;
    private volatile Entry<B> mFirst;
    private volatile Entry<B> mLast;

    public Entry<B> tryAccess() {
        Entry<B> e = this.mFirst;
        if (e != null) {
            while (true) {
                Entry next;
                if ((next = e.mNext) != null) {
                    cNextHandle.set(e, null);
                    this.mFirst = next;
                    break;
                }
                if (this.mLast == e && cLastHandle.compareAndSet(this, e, null)) {
                    cFirstHandle.compareAndSet(this, e, null);
                    break;
                }
                Thread.onSpinWait();
            }
        }
        return e;
    }

    public Entry<B> newEntry(B obj) {
        return new Entry<B>(this, obj);
    }

    private void release(Entry<B> entry) {
        Entry prev = cLastHandle.getAndSet(this, entry);
        if (prev == null) {
            this.mFirst = entry;
        } else {
            prev.mNext = entry;
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cFirstHandle = lookup.findVarHandle(WeakPool.class, "mFirst", Entry.class);
            cLastHandle = lookup.findVarHandle(WeakPool.class, "mLast", Entry.class);
            cNextHandle = lookup.findVarHandle(Entry.class, "mNext", Entry.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    public static final class Entry<B>
    extends WeakReference<B> {
        final WeakPool<B> mOwner;
        volatile Entry<B> mNext;

        Entry(WeakPool<B> owner, B obj) {
            super(obj);
            this.mOwner = owner;
        }

        public void release() {
            this.mOwner.release(this);
        }

        public void discard() {
        }
    }
}

