/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.LongAdder;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;

public class WideLatch {
    private final LongAdder mSharedAcquire = new LongAdder();
    private final LongAdder mSharedRelease = new LongAdder();
    private final Latch mFullLatch = new Latch();
    private volatile Thread mExclusiveThread;
    private static final VarHandle cExclusiveThreadHandle;

    public final boolean tryAcquireShared() {
        this.mSharedAcquire.increment();
        if (cExclusiveThreadHandle.getAcquire(this) != null) {
            this.releaseShared();
            return false;
        }
        return true;
    }

    public final boolean tryAcquireSharedNanos(long nanosTimeout) throws InterruptedException {
        this.mSharedAcquire.increment();
        if (cExclusiveThreadHandle.getAcquire(this) != null) {
            this.releaseShared();
            if (nanosTimeout < 0L) {
                this.mFullLatch.acquireSharedInterruptibly();
            } else if (nanosTimeout == 0L || !this.mFullLatch.tryAcquireSharedNanos(nanosTimeout)) {
                return false;
            }
            try {
                this.mSharedAcquire.increment();
            }
            finally {
                this.mFullLatch.releaseShared();
            }
        }
        return true;
    }

    public final void acquireShared() {
        this.mSharedAcquire.increment();
        if (cExclusiveThreadHandle.getAcquire(this) != null) {
            this.releaseShared();
            this.mFullLatch.acquireShared();
            try {
                this.mSharedAcquire.increment();
            }
            finally {
                this.mFullLatch.releaseShared();
            }
        }
    }

    public final void acquireSharedInterruptibly() throws InterruptedException {
        this.tryAcquireSharedNanos(-1L);
    }

    public final void releaseShared() {
        this.mSharedRelease.increment();
        Thread t = cExclusiveThreadHandle.getAcquire(this);
        if (t != null && !this.hasSharedLockers()) {
            Parker.unpark(t);
        }
    }

    public final void acquireExclusive() {
        long nanosTimeout = 1000L;
        while (!this.finishAcquireExclusive(nanosTimeout)) {
            nanosTimeout <<= 1;
        }
    }

    private boolean finishAcquireExclusive(long nanosTimeout) {
        this.mFullLatch.acquireExclusive();
        cExclusiveThreadHandle.setRelease(this, Thread.currentThread());
        try {
            block6: {
                if (this.hasSharedLockers()) {
                    long nanosEnd;
                    long l = nanosEnd = nanosTimeout <= 0L ? 0L : System.nanoTime() + nanosTimeout;
                    do {
                        if (nanosTimeout < 0L) {
                            Parker.park(this);
                        } else {
                            Parker.parkNanos(this, nanosTimeout);
                        }
                        Thread.interrupted();
                        if (!this.hasSharedLockers()) break block6;
                    } while (nanosTimeout < 0L || nanosTimeout != 0L && (nanosTimeout = nanosEnd - System.nanoTime()) > 0L);
                    this.releaseExclusive();
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
    }

    public final void releaseExclusive() {
        cExclusiveThreadHandle.setRelease(this, null);
        this.mFullLatch.releaseExclusive();
    }

    public final boolean hasQueuedThreads() {
        return this.mFullLatch.hasQueuedThreads();
    }

    private boolean hasSharedLockers() {
        return this.mSharedRelease.sum() != this.mSharedAcquire.sum();
    }

    static {
        try {
            cExclusiveThreadHandle = MethodHandles.lookup().findVarHandle(WideLatch.class, "mExclusiveThread", Thread.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

