/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Latch;

public class Worker {
    static final VarHandle cSizeHandle;
    static final VarHandle cFirstHandle;
    static final VarHandle cLastHandle;
    static final VarHandle cStateHandle;
    static final VarHandle cThreadHandle;
    private final ThreadFactory mThreadFactory;
    private final int mMaxSize;
    private final long mKeepAliveNanos;
    private volatile int mSize;
    private volatile Task mFirst;
    private volatile Task mLast;
    private static final int THREAD_NONE = 0;
    private static final int THREAD_RUNNING = 1;
    private static final int THREAD_BLOCKED = 2;
    private static final int THREAD_IDLE = 3;
    private volatile int mThreadState;
    private volatile Thread mThread;
    private Thread mWaiter;

    public static Worker make(int maxSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (threadFactory == null) {
            threadFactory = Executors.defaultThreadFactory();
        }
        return new Worker(maxSize, keepAliveTime, unit, threadFactory);
    }

    private Worker(int maxSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this.mThreadFactory = threadFactory;
        this.mMaxSize = maxSize;
        this.mKeepAliveNanos = keepAliveTime > 0L ? unit.toNanos(keepAliveTime) : keepAliveTime;
    }

    public boolean tryEnqueue(Task task) {
        int state;
        Task prev;
        if (task == null) {
            throw new NullPointerException();
        }
        int size = this.mSize;
        if (size >= this.mMaxSize) {
            return false;
        }
        if (!cSizeHandle.compareAndSet(this, size, size + 1)) {
            cSizeHandle.getAndAdd(this, 1);
        }
        if ((prev = cLastHandle.getAndSet(this, task)) == null) {
            this.mFirst = task;
        } else {
            prev.mNext = task;
        }
        do {
            Thread t;
            if ((state = this.mThreadState) == 1) {
                return true;
            }
            if (state != 0) continue;
            this.mThreadState = 1;
            try {
                t = this.mThreadFactory.newThread(this::runTasks);
                t.start();
            }
            catch (Throwable e) {
                cSizeHandle.getAndAdd(this, -1);
                this.mThreadState = 0;
                throw e;
            }
            this.mThread = t;
            return true;
        } while (!cStateHandle.compareAndSet(this, state, 1));
        LockSupport.unpark(this.mThread);
        return true;
    }

    public void enqueue(Task task) {
        while (!this.tryEnqueue(task)) {
            for (int i = 1; i < Latch.SPIN_LIMIT; ++i) {
                if (this.tryEnqueue(task)) {
                    return;
                }
                Thread.onSpinWait();
            }
            Thread.yield();
            if (this.tryEnqueue(task)) {
                return;
            }
            this.park();
        }
    }

    public void join(boolean interrupt) {
        while (this.mSize > 0) {
            for (int i = 1; i < Latch.SPIN_LIMIT && this.mSize > 0; ++i) {
                Thread.onSpinWait();
            }
            Thread.yield();
            if (this.mSize <= 0) break;
            this.park();
        }
        if (interrupt) {
            this.interrupt();
        }
    }

    private void park() {
        Thread t;
        this.mWaiter = t = Thread.currentThread();
        if (cStateHandle.compareAndSet(this, 1, 2)) {
            do {
                LockSupport.park(this);
                if (!t.isInterrupted()) continue;
                Thread.interrupted();
            } while (this.mThreadState == 2);
        }
        this.mWaiter = null;
    }

    public void interrupt() {
        Thread t = this.mThread;
        if (t != null) {
            t.interrupt();
        }
    }

    private void runTasks() {
        int size = 0;
        block2: while (true) {
            long endNanos;
            if (size > 0 || (size = this.mSize) > 0) {
                Task task;
                block12: {
                    while ((task = this.mFirst) == null) {
                        Thread.onSpinWait();
                    }
                    do {
                        Task next;
                        if ((next = task.mNext) == null) continue;
                        this.mFirst = next;
                        break block12;
                    } while (task != this.mLast || !cLastHandle.compareAndSet(this, task, null));
                    cFirstHandle.compareAndSet(this, task, null);
                }
                try {
                    task.run();
                }
                catch (Throwable e) {
                    Utils.uncaught(e);
                }
                size = cSizeHandle.getAndAdd(this, -1) - 1;
                if (this.mThreadState != 2) continue;
                this.mThreadState = 1;
                LockSupport.unpark(this.mWaiter);
                continue;
            }
            for (int i = 0; i < Latch.SPIN_LIMIT; ++i) {
                size = this.mSize;
                if (size > 0) continue block2;
                if (this.mThreadState == 2) {
                    this.mThreadState = 1;
                    LockSupport.unpark(this.mWaiter);
                    continue;
                }
                Thread.onSpinWait();
            }
            Thread.yield();
            size = this.mSize;
            if (size > 0 || !cStateHandle.compareAndSet(this, 1, 3)) continue;
            long parkNanos = this.mKeepAliveNanos;
            long l = endNanos = parkNanos < 0L ? 0L : System.nanoTime() + parkNanos;
            while ((size = this.mSize) <= 0) {
                if (parkNanos < 0L) {
                    LockSupport.park(this);
                } else {
                    LockSupport.parkNanos(this, parkNanos);
                    parkNanos = Math.max(0L, endNanos - System.nanoTime());
                }
                boolean interrupted = Thread.interrupted();
                size = this.mSize;
                if (size > 0) break;
                if (parkNanos == 0L || interrupted) {
                    if (!cStateHandle.compareAndSet(this, 3, 0)) continue block2;
                    cThreadHandle.compareAndSet(this, Thread.currentThread(), null);
                    return;
                }
                if (this.mThreadState == 3) continue;
                continue block2;
            }
            cStateHandle.compareAndSet(this, 3, 1);
        }
    }

    static {
        try {
            Class<LockSupport> clazz = LockSupport.class;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cSizeHandle = lookup.findVarHandle(Worker.class, "mSize", Integer.TYPE);
            cFirstHandle = lookup.findVarHandle(Worker.class, "mFirst", Task.class);
            cLastHandle = lookup.findVarHandle(Worker.class, "mLast", Task.class);
            cStateHandle = lookup.findVarHandle(Worker.class, "mThreadState", Integer.TYPE);
            cThreadHandle = lookup.findVarHandle(Worker.class, "mThread", Thread.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    public static abstract class Task {
        volatile Task mNext;

        public abstract void run() throws Throwable;
    }
}

