/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.util.Worker;

public abstract class WorkerGroup {
    public static WorkerGroup make(int workerCount, int maxSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        if (workerCount < 1) {
            throw new IllegalArgumentException();
        }
        if (threadFactory == null) {
            threadFactory = Executors.defaultThreadFactory();
        }
        if (workerCount == 1) {
            return new One(Worker.make(maxSize, keepAliveTime, unit, threadFactory));
        }
        return new Many(workerCount, maxSize, keepAliveTime, unit, threadFactory);
    }

    WorkerGroup() {
    }

    public abstract Worker tryEnqueue(Worker.Task var1);

    public abstract Worker enqueue(Worker.Task var1);

    public abstract void join(boolean var1);

    public abstract void interrupt();

    private static final class One
    extends WorkerGroup {
        private final Worker mWorker;

        One(Worker worker) {
            this.mWorker = worker;
        }

        @Override
        public Worker tryEnqueue(Worker.Task task) {
            this.mWorker.tryEnqueue(task);
            return this.mWorker;
        }

        @Override
        public Worker enqueue(Worker.Task task) {
            this.mWorker.enqueue(task);
            return this.mWorker;
        }

        @Override
        public void join(boolean interrupt) {
            this.mWorker.join(interrupt);
        }

        @Override
        public void interrupt() {
            this.mWorker.interrupt();
        }
    }

    private static final class Many
    extends WorkerGroup {
        private final Worker[] mWorkers;
        private int mLastSelected;

        Many(int workerCount, int maxSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
            Worker[] workers = new Worker[workerCount];
            for (int i = 0; i < workers.length; ++i) {
                workers[i] = Worker.make(maxSize, keepAliveTime, unit, threadFactory);
            }
            this.mWorkers = workers;
        }

        @Override
        public Worker tryEnqueue(Worker.Task task) {
            int slot = Math.max(0, this.mLastSelected - 1);
            for (int i = 0; i < this.mWorkers.length; ++i) {
                Worker w = this.mWorkers[slot];
                if (w.tryEnqueue(task)) {
                    this.mLastSelected = slot;
                    return w;
                }
                if (++slot < this.mWorkers.length) continue;
                slot = 0;
            }
            return null;
        }

        @Override
        public Worker enqueue(Worker.Task task) {
            Worker w = this.tryEnqueue(task);
            if (w == null) {
                this.mLastSelected = ThreadLocalRandom.current().nextInt(this.mWorkers.length);
                w = this.mWorkers[this.mLastSelected];
                w.enqueue(task);
            }
            return w;
        }

        @Override
        public void join(boolean interrupt) {
            for (Worker w : this.mWorkers) {
                w.join(interrupt);
            }
        }

        @Override
        public void interrupt() {
            for (Worker w : this.mWorkers) {
                w.interrupt();
            }
        }
    }
}

