/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.views.BoundedView;
import org.cojen.tupl.views.ViewUtils;

final class BoundedCursor
implements Cursor {
    final BoundedView mView;
    final Cursor mSource;
    private boolean mOutOfBounds;

    BoundedCursor(BoundedView view, Cursor source) {
        this.mView = view;
        this.mSource = source;
    }

    @Override
    public long valueLength() throws IOException {
        return this.mSource.valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        this.mSource.valueLength(length);
    }

    @Override
    public int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        return this.mSource.valueRead(pos, buf, off, len);
    }

    @Override
    public void valueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        this.mSource.valueWrite(pos, buf, off, len);
    }

    @Override
    public void valueClear(long pos, long length) throws IOException {
        this.mSource.valueClear(pos, length);
    }

    @Override
    public InputStream newValueInputStream(long pos) throws IOException {
        return this.mSource.newValueInputStream(pos);
    }

    @Override
    public InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueInputStream(pos, bufferSize);
    }

    @Override
    public OutputStream newValueOutputStream(long pos) throws IOException {
        return this.mSource.newValueOutputStream(pos);
    }

    @Override
    public OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueOutputStream(pos, bufferSize);
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        return this.mSource.key();
    }

    @Override
    public byte[] value() {
        return this.mOutOfBounds ? null : this.mSource.value();
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mSource.compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return this.mSource.compareKeyTo(rkey, offset, length);
    }

    @Override
    public boolean register() throws IOException {
        return this.mSource.register();
    }

    @Override
    public void unregister() {
        this.mSource.unregister();
    }

    @Override
    public LockResult first() throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        byte[] start = view.mStart;
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            result = start == null ? source.first() : ((view.mMode & 0xFFFFFFFE) == 0 ? source.findGe(start) : source.findGt(start));
        } else if (start == null) {
            result = source.first();
            byte[] key = source.key();
            if (key == null) {
                result = LockResult.UNOWNED;
            } else if (view.endRangeCompare(view.mEnd, key) > 0) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                source.reset();
                result = LockResult.UNOWNED;
            }
        } else if (view.endRangeCompare(view.mEnd, start) > 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else if ((view.mMode & 0xFFFFFFFE) == 0) {
            result = source.find(start);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.next();
            }
        } else {
            ViewUtils.findNoLock(source, start);
            return this.next();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult last() throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        byte[] end = view.mEnd;
        Cursor source = this.mSource;
        if (view.mStart == null) {
            result = end == null ? source.last() : ((view.mMode & 1) == 0 ? source.findLe(end) : source.findLt(end));
        } else if (end == null) {
            result = source.last();
            byte[] key = source.key();
            if (key == null) {
                result = LockResult.UNOWNED;
            } else if (view.startRangeCompare(view.mStart, key) < 0) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                source.reset();
                result = LockResult.UNOWNED;
            }
        } else if (view.startRangeCompare(view.mStart, end) < 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else if ((view.mMode & 1) == 0) {
            result = source.find(end);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.previous();
            }
        } else {
            ViewUtils.findNoLock(source, end);
            return this.previous();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        boolean inclusive;
        byte[] limitKey;
        BoundedView view = this.mView;
        if (amount >= 0L) {
            limitKey = view.mEnd;
            inclusive = (view.mMode & 1) == 0;
        } else {
            limitKey = view.mStart;
            inclusive = (view.mMode & 0xFFFFFFFE) == 0;
        }
        LockResult result = this.mSource.skip(amount, limitKey, inclusive);
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        LockResult result;
        if (amount == 0L || limitKey == null) {
            result = this.mSource.skip(0L);
        } else {
            BoundedView view = this.mView;
            if (amount > 0L) {
                if (view.endRangeCompare(limitKey) > 0) {
                    limitKey = view.mEnd;
                    inclusive = (view.mMode & 1) == 0;
                }
            } else if (view.startRangeCompare(limitKey) < 0) {
                limitKey = view.mStart;
                inclusive = (view.mMode & 0xFFFFFFFE) == 0;
            }
            result = this.mSource.skip(amount, limitKey, inclusive);
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult next() throws IOException {
        BoundedView view = this.mView;
        byte[] end = view.mEnd;
        Cursor source = this.mSource;
        LockResult result = end == null ? source.next() : ((view.mMode & 1) == 0 ? source.nextLe(end) : source.nextLt(end));
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        if (this.mView.endRangeCompare(limitKey) <= 0) {
            LockResult result = this.mSource.nextLe(limitKey);
            this.mOutOfBounds = false;
            return result;
        }
        return this.next();
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        if (this.mView.endRangeCompare(limitKey) <= 0) {
            LockResult result = this.mSource.nextLt(limitKey);
            this.mOutOfBounds = false;
            return result;
        }
        return this.next();
    }

    @Override
    public LockResult previous() throws IOException {
        BoundedView view = this.mView;
        byte[] start = view.mStart;
        Cursor source = this.mSource;
        LockResult result = start == null ? source.previous() : ((view.mMode & 0xFFFFFFFE) == 0 ? source.previousGe(start) : source.previousGt(start));
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        if (this.mView.startRangeCompare(limitKey) >= 0) {
            LockResult result = this.mSource.previousGe(limitKey);
            this.mOutOfBounds = false;
            return result;
        }
        return this.previous();
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        if (this.mView.startRangeCompare(limitKey) >= 0) {
            LockResult result = this.mSource.previousGt(limitKey);
            this.mOutOfBounds = false;
            return result;
        }
        return this.previous();
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        if (this.mView.inRange(key)) {
            LockResult result = this.mSource.find(key);
            this.mOutOfBounds = false;
            return result;
        }
        this.mOutOfBounds = true;
        ViewUtils.findNoLock(this.mSource, key);
        return LockResult.UNOWNED;
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            result = source.findGe(key);
        } else if (view.endRangeCompare(view.mEnd, key) > 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            result = source.find(key);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.next();
            }
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            result = source.findGt(key);
        } else if (view.endRangeCompare(view.mEnd, key) > 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            ViewUtils.findNoLock(source, key);
            return this.next();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            result = source.findLe(key);
        } else if (view.startRangeCompare(view.mStart, key) < 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            result = source.find(key);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.previous();
            }
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            result = source.findLt(key);
        } else if (view.startRangeCompare(view.mStart, key) < 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            ViewUtils.findNoLock(source, key);
            return this.previous();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        if (this.mView.inRange(key)) {
            LockResult result = this.mSource.findNearby(key);
            this.mOutOfBounds = false;
            return result;
        }
        this.mOutOfBounds = true;
        ViewUtils.findNearbyNoLock(this.mSource, key);
        return LockResult.UNOWNED;
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            result = source.findNearbyGe(key);
        } else if (view.endRangeCompare(view.mEnd, key) > 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            result = source.findNearby(key);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.next();
            }
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.startRangeCompare(key) < 0) {
            return this.first();
        }
        Cursor source = this.mSource;
        if (view.mEnd == null) {
            result = source.findNearbyGt(key);
        } else if (view.endRangeCompare(view.mEnd, key) > 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            ViewUtils.findNearbyNoLock(source, key);
            return this.next();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            result = source.findNearbyLe(key);
        } else if (view.startRangeCompare(view.mStart, key) < 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            result = source.findNearby(key);
            if (source.value() == null) {
                if (result == LockResult.ACQUIRED) {
                    source.link().unlock();
                }
                return this.previous();
            }
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        LockResult result;
        BoundedView view = this.mView;
        if (view.endRangeCompare(key) > 0) {
            return this.last();
        }
        Cursor source = this.mSource;
        if (view.mStart == null) {
            result = source.findNearbyLt(key);
        } else if (view.startRangeCompare(view.mStart, key) < 0) {
            source.reset();
            result = LockResult.UNOWNED;
        } else {
            ViewUtils.findNearbyNoLock(source, key);
            return this.previous();
        }
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        byte[] end;
        byte[] start = this.mView.mStart;
        if (start != null && (lowKey == null || this.mView.startRangeCompare(start, lowKey) < 0)) {
            lowKey = start;
            boolean bl = lowInclusive = (this.mView.mMode & 0xFFFFFFFE) == 0;
        }
        if ((end = this.mView.mEnd) != null && (highKey == null || this.mView.endRangeCompare(end, highKey) > 0)) {
            highKey = end;
            highInclusive = (this.mView.mMode & 1) == 0;
        }
        LockResult result = this.mSource.random(lowKey, lowInclusive, highKey, highInclusive);
        this.mOutOfBounds = false;
        return result;
    }

    @Override
    public boolean exists() throws IOException {
        if (this.mOutOfBounds) {
            throw BoundedView.fail();
        }
        return this.mSource.exists();
    }

    @Override
    public LockResult lock() throws IOException {
        if (this.mOutOfBounds) {
            throw BoundedView.fail();
        }
        return this.mSource.lock();
    }

    @Override
    public LockResult load() throws IOException {
        if (this.mOutOfBounds) {
            throw BoundedView.fail();
        }
        return this.mSource.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        if (this.mOutOfBounds) {
            throw BoundedView.fail();
        }
        this.mSource.store(value);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        if (this.mOutOfBounds) {
            throw BoundedView.fail();
        }
        this.mSource.commit(value);
    }

    @Override
    public Cursor copy() {
        BoundedCursor copy = new BoundedCursor(this.mView, this.mSource.copy());
        copy.mOutOfBounds = this.mOutOfBounds;
        return copy;
    }

    @Override
    public void reset() {
        this.mSource.reset();
        this.mOutOfBounds = false;
    }

    @Override
    public void close() throws IOException {
        this.mSource.close();
        this.mOutOfBounds = false;
    }
}

