/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.views.BoundedCursor;
import org.cojen.tupl.views.SubView;
import org.cojen.tupl.views.TrimmedView;

public final class BoundedView
extends SubView {
    static final int START_EXCLUSIVE = -2;
    static final int END_EXCLUSIVE = 1;
    final byte[] mStart;
    final byte[] mEnd;
    final int mMode;

    public static View viewGe(View view, byte[] key) {
        Utils.keyCheck(key);
        return new BoundedView(view, key, null, 0);
    }

    public static View viewGt(View view, byte[] key) {
        Utils.keyCheck(key);
        return new BoundedView(view, key, null, -2);
    }

    public static View viewLe(View view, byte[] key) {
        Utils.keyCheck(key);
        return new BoundedView(view, null, key, 0);
    }

    public static View viewLt(View view, byte[] key) {
        Utils.keyCheck(key);
        return new BoundedView(view, null, key, 1);
    }

    public static View viewPrefix(View view, byte[] prefix, int trim) {
        int mode;
        BoundedView.prefixCheck(prefix, trim);
        byte[] end = (byte[])prefix.clone();
        if (Utils.increment(end, 0, end.length)) {
            mode = 1;
        } else {
            end = null;
            mode = 0;
        }
        view = new BoundedView(view, prefix, end, mode);
        if (trim > 0) {
            view = new TrimmedView(view, prefix, trim);
        }
        return view;
    }

    BoundedView(View source, byte[] start, byte[] end, int mode) {
        super(source);
        this.mStart = start;
        this.mEnd = end;
        this.mMode = mode;
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new BoundedCursor(this, this.mSource.newCursor(txn));
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        byte[] end;
        byte[] start = this.mStart;
        if (start != null && (lowKey == null || this.startRangeCompare(start, lowKey) < 0)) {
            lowKey = start;
            boolean bl = lowInclusive = (this.mMode & 0xFFFFFFFE) == 0;
        }
        if ((end = this.mEnd) != null && (highKey == null || this.endRangeCompare(end, highKey) > 0)) {
            highKey = end;
            highInclusive = (this.mMode & 1) == 0;
        }
        return this.mSource.count(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public View viewGe(byte[] key) {
        Utils.keyCheck(key);
        if (this.startRangeCompare(key) <= 0) {
            return this;
        }
        return new BoundedView(this.mSource, key, this.mEnd, this.mMode & 1);
    }

    @Override
    public View viewGt(byte[] key) {
        Utils.keyCheck(key);
        if (this.startRangeCompare(key) < 0) {
            return this;
        }
        return new BoundedView(this.mSource, key, this.mEnd, this.mMode | 0xFFFFFFFE);
    }

    @Override
    public View viewLe(byte[] key) {
        Utils.keyCheck(key);
        if (this.endRangeCompare(key) >= 0) {
            return this;
        }
        return new BoundedView(this.mSource, this.mStart, key, this.mMode & 0xFFFFFFFE);
    }

    @Override
    public View viewLt(byte[] key) {
        Utils.keyCheck(key);
        if (this.endRangeCompare(key) > 0) {
            return this;
        }
        return new BoundedView(this.mSource, this.mStart, key, this.mMode | 1);
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        SubView.prefixCheck(prefix, trim);
        View view = this.viewGe(prefix);
        byte[] end = (byte[])prefix.clone();
        if (Utils.increment(end, 0, end.length)) {
            view = view.viewLt(end);
        }
        if (trim > 0) {
            view = new TrimmedView(view, prefix, trim);
        }
        return view;
    }

    @Override
    boolean inRange(byte[] key) {
        return this.startRangeCompare(key) >= 0 && this.endRangeCompare(key) <= 0;
    }

    int startRangeCompare(byte[] key) {
        byte[] start = this.mStart;
        return start == null ? 1 : this.startRangeCompare(start, key);
    }

    int startRangeCompare(byte[] start, byte[] key) {
        int result = Arrays.compareUnsigned(key, start);
        return result != 0 ? result : this.mMode & 0xFFFFFFFE;
    }

    int endRangeCompare(byte[] key) {
        byte[] end = this.mEnd;
        return end == null ? -1 : this.endRangeCompare(end, key);
    }

    int endRangeCompare(byte[] end, byte[] key) {
        int result = Arrays.compareUnsigned(key, end);
        return result != 0 ? result : this.mMode & 1;
    }
}

