/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.views.MergeCursor;
import org.cojen.tupl.views.MergeView;

final class IntersectionCursor
extends MergeCursor {
    IntersectionCursor(Transaction txn, MergeView view, Cursor first, Cursor second) {
        super(txn, view, first, second);
    }

    @Override
    public boolean exists() throws IOException {
        return this.mFirst.exists() && this.mSecond.exists();
    }

    @Override
    protected MergeCursor newCursor(Cursor first, Cursor second) {
        return new IntersectionCursor(this.mTxn, this.mView, first, second);
    }

    @Override
    protected LockResult select(Transaction txn) throws IOException {
        while (true) {
            byte[] k1;
            if ((k1 = this.mFirst.key()) == null) {
                this.reset();
                return LockResult.UNOWNED;
            }
            byte[] k2 = this.mSecond.key();
            if (k2 == null) {
                this.reset();
                return LockResult.UNOWNED;
            }
            int cmp = this.comparator().compare(k1, k2);
            if (cmp == 0) {
                this.mCompare = cmp;
                return this.selectCombine(txn, k1);
            }
            if (this.mDirection == 0) {
                if (cmp < 0) {
                    this.mFirst.findNearbyGe(k2);
                    continue;
                }
                this.mSecond.findNearbyGe(k1);
                continue;
            }
            if (cmp > 0) {
                this.mFirst.findNearbyLe(k2);
                continue;
            }
            this.mSecond.findNearbyLe(k1);
        }
    }

    @Override
    protected void doStore(byte[] key, byte[] value) throws IOException {
        block3: {
            byte[] second;
            byte[] first;
            block5: {
                block4: {
                    block2: {
                        if (value != null) break block2;
                        this.mFirst.store(null);
                        break block3;
                    }
                    byte[][] values = this.mView.mCombiner.separate(key, value);
                    if (values == null) break block4;
                    first = values[0];
                    second = values[1];
                    if (first != null && second != null) break block5;
                }
                throw this.storeFail();
            }
            this.mFirst.store(first);
            this.mSecond.store(second);
        }
    }
}

