/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.NoSuchValueException;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.views.KeyOnlyView;
import org.cojen.tupl.views.WrappedCursor;

final class KeyOnlyCursor
extends WrappedCursor {
    KeyOnlyCursor(Cursor source) {
        super(source);
        source.autoload(false);
    }

    @Override
    public long valueLength() throws IOException {
        return this.source.valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        if (length >= 0L) {
            throw new ViewConstraintException();
        }
        this.source.store(null);
    }

    @Override
    public int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        return this.source.valueRead(pos, buf, off, 0);
    }

    @Override
    public InputStream newValueInputStream(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (KeyOnlyCursor.this.value() == null) {
                    throw new NoSuchValueException();
                }
                return -1;
            }
        };
    }

    @Override
    public InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        return this.newValueInputStream(pos);
    }

    @Override
    public OutputStream newValueOutputStream(long pos) throws IOException {
        throw new ViewConstraintException();
    }

    @Override
    public OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        return this.newValueOutputStream(pos);
    }

    @Override
    public byte[] value() {
        return KeyOnlyView.valueScrub(this.source.value());
    }

    @Override
    public boolean autoload(boolean mode) {
        return false;
    }

    @Override
    public boolean autoload() {
        return false;
    }

    @Override
    public LockResult load() throws IOException {
        return this.source.lock();
    }

    @Override
    public void store(byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        this.source.store(null);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        this.source.commit(null);
    }

    @Override
    public Cursor copy() {
        return new KeyOnlyCursor(this.source.copy());
    }
}

