/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.views.KeyOnlyCursor;
import org.cojen.tupl.views.UnmodifiableView;

public final class KeyOnlyView
implements View {
    private final View mSource;

    public KeyOnlyView(View source) {
        this.mSource = source;
    }

    static void valueCheck(byte[] value) throws ViewConstraintException {
        if (value != null) {
            throw new ViewConstraintException("Cannot store non-null value into key-only view");
        }
    }

    static byte[] valueScrub(byte[] value) {
        return value == null ? null : Cursor.NOT_LOADED;
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new KeyOnlyCursor(this.mSource.newCursor(txn));
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.count(lowKey, highKey);
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mSource.count(lowKey, lowInclusive, highKey, highInclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        Cursor c = this.mSource.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            byte[] byArray = KeyOnlyView.valueScrub(c.value());
            return byArray;
        }
        finally {
            c.reset();
        }
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.mSource.exists(txn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        Cursor c = this.mSource.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            byte[] old = KeyOnlyView.valueScrub(c.value());
            c.store(value);
            byte[] byArray = old;
            return byArray;
        }
        finally {
            c.reset();
        }
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        this.mSource.store(txn, key, null);
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        return this.mSource.insert(txn, key, null);
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        return this.mSource.replace(txn, key, null);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        KeyOnlyView.valueCheck(value);
        return this.mSource.update(txn, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        KeyOnlyView.valueCheck(newValue);
        if (oldValue == null) {
            return this.mSource.update(txn, key, null, null);
        }
        Cursor c = this.mSource.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            if (KeyOnlyView.valueScrub(c.value()) != oldValue) {
                boolean bl = false;
                return bl;
            }
            c.store(null);
            boolean bl = true;
            return bl;
        }
        finally {
            c.reset();
        }
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.mSource.delete(txn, key);
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.mSource.touch(txn, key);
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockShared(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockShared(txn, key);
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockUpgradable(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockUpgradable(txn, key);
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockExclusive(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockExclusive(txn, key);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mSource.lockCheck(txn, key);
    }

    @Override
    public View viewKeys() {
        return this;
    }

    @Override
    public View viewReverse() {
        return new KeyOnlyView(this.mSource.viewReverse());
    }

    @Override
    public View viewUnmodifiable() {
        View source = this.mSource.viewUnmodifiable();
        return source == this.mSource ? this : UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mSource.isModifyAtomic();
    }
}

