/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.cojen.tupl.Combiner;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.core.CoreValueAccessor;
import org.cojen.tupl.views.MergeView;
import org.cojen.tupl.views.ViewUtils;

abstract class MergeCursor
extends CoreValueAccessor
implements Cursor {
    static final int DIRECTION_FORWARD = 0;
    static final int DIRECTION_REVERSE = -1;
    final MergeView mView;
    final Cursor mFirst;
    final Cursor mSecond;
    Transaction mTxn;
    boolean mKeyOnly;
    int mDirection;
    byte[] mKey;
    byte[] mValue;
    int mCompare;

    MergeCursor(Transaction txn, MergeView view, Cursor first, Cursor second) {
        this.mView = view;
        this.mFirst = first;
        this.mSecond = second;
        this.mTxn = txn;
    }

    @Override
    public Ordering ordering() {
        return this.mView.mOrdering;
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mView.comparator();
    }

    @Override
    public Transaction link(Transaction txn) {
        Transaction old = this.mTxn;
        this.mTxn = txn;
        return old;
    }

    @Override
    public Transaction link() {
        return this.mTxn;
    }

    @Override
    public byte[] key() {
        return this.mKey;
    }

    @Override
    public byte[] value() {
        return this.mValue;
    }

    @Override
    public boolean autoload(boolean mode) {
        boolean old = !this.mKeyOnly;
        this.mKeyOnly = !mode;
        return old;
    }

    @Override
    public boolean autoload() {
        return !this.mKeyOnly;
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mKey == this.mFirst.key() ? this.mFirst.compareKeyTo(rkey) : this.mSecond.compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return this.mKey == this.mFirst.key() ? this.mFirst.compareKeyTo(rkey, offset, length) : this.mSecond.compareKeyTo(rkey, offset, length);
    }

    @Override
    public boolean register() throws IOException {
        return this.mFirst.register() || this.mSecond.register();
    }

    @Override
    public void unregister() {
        this.mFirst.unregister();
        this.mSecond.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult perform(Action action) throws IOException {
        Transaction txn = this.mTxn;
        if (this.mView.mCombiner.combineLocks()) {
            if (txn == null) {
                txn = this.mView.newTransaction(null);
                try {
                    txn.lockMode(LockMode.REPEATABLE_READ);
                    action.perform(txn);
                }
                finally {
                    txn.reset();
                }
                return LockResult.UNOWNED;
            }
            if (txn.lockMode() == LockMode.READ_COMMITTED) {
                LockResult result;
                LockMode original = txn.lockMode();
                try {
                    txn.lockMode(LockMode.REPEATABLE_READ);
                    result = action.perform(txn);
                    if (result.isAcquired()) {
                        txn.unlock();
                        result = LockResult.UNOWNED;
                    }
                }
                finally {
                    txn.lockMode(original);
                }
                return result;
            }
        }
        return action.perform(txn);
    }

    @Override
    public LockResult first() throws IOException {
        return this.perform(txn -> {
            this.mKey = null;
            this.mValue = null;
            this.mCompare = 0;
            this.mDirection = 0;
            this.mFirst.first();
            this.mSecond.first();
            return this.selectNext(txn);
        });
    }

    @Override
    public LockResult last() throws IOException {
        return this.perform(txn -> {
            this.mKey = null;
            this.mValue = null;
            this.mCompare = 0;
            this.mDirection = -1;
            this.mFirst.last();
            this.mSecond.last();
            return this.selectPrevious(txn);
        });
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        if (amount == 0L) {
            return ViewUtils.commonOwned(this.mFirst.skip(0L), this.mSecond.skip(0L));
        }
        return ViewUtils.skipWithLocks(this, amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return ViewUtils.skipWithLocks(this, amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        return this.perform(txn -> {
            int cmp = this.mCompare;
            if (cmp == 0) {
                this.mFirst.next();
                this.mSecond.next();
                this.mDirection = 0;
            } else {
                if (this.mDirection == -1) {
                    this.switchToForward(txn);
                    cmp = this.mCompare;
                }
                if (cmp < 0) {
                    this.mFirst.next();
                } else {
                    this.mSecond.next();
                }
            }
            return this.selectNext(txn);
        });
    }

    private LockResult selectNext(Transaction txn) throws IOException {
        LockResult result;
        while ((result = this.select(txn)) == null) {
            boolean sn;
            boolean fn = this.mFirst.value() == null;
            if (fn | !(sn = this.mSecond.value() == null) && this.mFirst.key() != null) {
                this.mFirst.next();
            }
            if (!(sn | !fn) || this.mSecond.key() == null) continue;
            this.mSecond.next();
        }
        return result;
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, Cursor::nextLe);
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, Cursor::nextLt);
    }

    private LockResult nextCmp(byte[] limitKey, KeyAction action) throws IOException {
        return this.perform(txn -> {
            int cmp = this.mCompare;
            if (cmp == 0) {
                action.perform(this.mFirst, limitKey);
                action.perform(this.mSecond, limitKey);
                this.mDirection = 0;
            } else {
                if (this.mDirection == -1) {
                    this.switchToForward(txn);
                    cmp = this.mCompare;
                }
                action.perform(cmp < 0 ? this.mFirst : this.mSecond, limitKey);
            }
            return this.select(txn, limitKey, action);
        });
    }

    private LockResult select(Transaction txn, byte[] limitKey, KeyAction action) throws IOException {
        LockResult result;
        while ((result = this.select(txn)) == null) {
            boolean sn;
            boolean fn = this.mFirst.value() == null;
            if (fn | !(sn = this.mSecond.value() == null)) {
                action.perform(this.mFirst, limitKey);
            }
            if (!(sn | !fn)) continue;
            action.perform(this.mSecond, limitKey);
        }
        return result;
    }

    private void switchToForward(Transaction txn) throws IOException {
        this.mDirection = 0;
        (this.mKey == this.mFirst.key() ? this.mSecond : this.mFirst).findNearbyGt(this.mKey);
        this.select(txn);
    }

    @Override
    public LockResult previous() throws IOException {
        return this.perform(txn -> {
            int cmp = this.mCompare;
            if (cmp == 0) {
                this.mFirst.previous();
                this.mSecond.previous();
                this.mDirection = -1;
            } else {
                if (this.mDirection == 0) {
                    this.switchToReverse(txn);
                    cmp = this.mCompare;
                }
                if (cmp > 0) {
                    this.mFirst.previous();
                } else {
                    this.mSecond.previous();
                }
            }
            return this.selectPrevious(txn);
        });
    }

    private LockResult selectPrevious(Transaction txn) throws IOException {
        LockResult result;
        while ((result = this.select(txn)) == null) {
            boolean sn;
            boolean fn = this.mFirst.value() == null;
            if (fn | !(sn = this.mSecond.value() == null) && this.mFirst.key() != null) {
                this.mFirst.previous();
            }
            if (!(sn | !fn) || this.mSecond.key() == null) continue;
            this.mSecond.previous();
        }
        return result;
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, Cursor::previousGe);
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, Cursor::previousGt);
    }

    private LockResult previousCmp(byte[] limitKey, KeyAction action) throws IOException {
        return this.perform(txn -> {
            int cmp = this.mCompare;
            if (cmp == 0) {
                action.perform(this.mFirst, limitKey);
                action.perform(this.mSecond, limitKey);
                this.mDirection = -1;
            } else {
                if (this.mDirection == 0) {
                    this.switchToReverse(txn);
                    cmp = this.mCompare;
                }
                action.perform(cmp > 0 ? this.mFirst : this.mSecond, limitKey);
            }
            return this.select(txn, limitKey, action);
        });
    }

    private void switchToReverse(Transaction txn) throws IOException {
        this.mDirection = -1;
        (this.mKey == this.mFirst.key() ? this.mSecond : this.mFirst).findNearbyLt(this.mKey);
        this.select(txn);
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::find);
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::findGe);
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::findGt);
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        return this.doFind(-1, key, Cursor::findLe);
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        return this.doFind(-1, key, Cursor::findLt);
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::findNearby);
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::findNearbyGe);
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        return this.doFind(0, key, Cursor::findNearbyGt);
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        return this.doFind(-1, key, Cursor::findNearbyLe);
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        return this.doFind(-1, key, Cursor::findNearbyLt);
    }

    private LockResult doFind(int direction, byte[] key, KeyAction action) throws IOException {
        return this.perform(txn -> {
            action.perform(this.mFirst, key);
            action.perform(this.mSecond, key);
            this.mDirection = direction;
            LockResult result = this.select(txn);
            return result == null ? LockResult.UNOWNED : result;
        });
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        this.reset();
        return LockResult.UNOWNED;
    }

    @Override
    public LockResult lock() throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        return this.perform(txn -> {
            LockResult result;
            this.alignKeys(key);
            if (this.mKeyOnly) {
                result = this.select(txn);
            } else {
                this.mKeyOnly = true;
                try {
                    boolean oFirst = this.mFirst.autoload(true);
                    try {
                        boolean oSecond = this.mSecond.autoload(true);
                        try {
                            result = this.select(txn);
                        }
                        finally {
                            this.mSecond.autoload(oSecond);
                        }
                    }
                    finally {
                        this.mFirst.autoload(oFirst);
                    }
                }
                finally {
                    this.mKeyOnly = false;
                }
            }
            return result == null ? LockResult.UNOWNED : result;
        });
    }

    @Override
    public LockResult load() throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        return this.perform(txn -> {
            this.alignKeys(key);
            boolean original = this.autoload(true);
            try {
                LockResult result = this.select(txn);
                LockResult lockResult = result == null ? LockResult.UNOWNED : result;
                return lockResult;
            }
            finally {
                this.autoload(original);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(byte[] value) throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        Transaction txn = this.mTxn;
        if (txn == null) {
            txn = this.mView.newTransaction(null);
            try {
                this.store(txn, key, value);
                txn.commit();
            }
            finally {
                txn.reset();
            }
        } else if (txn.lockMode() != LockMode.UNSAFE) {
            txn.enter();
            try {
                this.store(txn, key, value);
                txn.commit();
            }
            finally {
                txn.exit();
            }
        } else {
            this.store(txn, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        this.alignKeys(key);
        try {
            this.mFirst.link(txn);
            this.mSecond.link(txn);
            this.doStore(key, value);
        }
        finally {
            this.mFirst.link(Transaction.BOGUS);
            this.mSecond.link(Transaction.BOGUS);
        }
        this.mValue = value;
    }

    private void alignKeys(byte[] key) throws IOException {
        if (this.mCompare != 0) {
            if (!Arrays.equals(key, this.mFirst.key())) {
                this.mFirst.findNearby(key);
            }
            if (!Arrays.equals(key, this.mSecond.key())) {
                this.mSecond.findNearby(key);
            }
            this.mCompare = 0;
        }
    }

    @Override
    public Cursor copy() {
        MergeCursor copy = this.newCursor(this.mFirst.copy(), this.mSecond.copy());
        copy.mTxn = this.mTxn;
        copy.mKeyOnly = this.mKeyOnly;
        copy.mDirection = this.mDirection;
        copy.mKey = this.mKey;
        copy.mValue = ViewUtils.copyValue(this.mValue);
        copy.mCompare = this.mCompare;
        return copy;
    }

    @Override
    public void reset() {
        this.mDirection = 0;
        this.mKey = null;
        this.mValue = null;
        this.mCompare = 0;
        this.mFirst.reset();
        this.mSecond.reset();
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public long valueLength() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void valueLength(long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int doValueRead(long pos, byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doValueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doValueClear(long pos, long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int valueStreamBufferSize(int bufferSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void valueCheckOpen() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockResult selectFirst(Transaction txn, byte[] key) throws IOException {
        this.mKey = key;
        this.mValue = Cursor.NOT_LOADED;
        this.mFirst.link(txn);
        try {
            LockResult r1 = this.autoload() ? this.mFirst.load() : this.mFirst.lock();
            LockResult r2 = this.mView.mSecond.touch(txn, key);
            byte[] value = this.mFirst.value();
            this.mValue = value;
            if (value == null) {
                if (r1.isAcquired()) {
                    txn.unlock();
                }
                if (r2.isAcquired()) {
                    txn.unlock();
                }
                LockResult lockResult = null;
                return lockResult;
            }
            LockResult lockResult = this.resultCombine(txn, r1, r2);
            return lockResult;
        }
        finally {
            this.mFirst.link(Transaction.BOGUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockResult selectSecond(Transaction txn, byte[] key) throws IOException {
        this.mKey = key;
        this.mValue = Cursor.NOT_LOADED;
        this.mSecond.link(txn);
        try {
            LockResult r1 = this.mView.mFirst.touch(txn, key);
            LockResult r2 = this.autoload() ? this.mSecond.load() : this.mSecond.lock();
            byte[] value = this.mSecond.value();
            this.mValue = value;
            if (value == null) {
                if (r1.isAcquired()) {
                    txn.unlock();
                }
                if (r2.isAcquired()) {
                    txn.unlock();
                }
                LockResult lockResult = null;
                return lockResult;
            }
            LockResult lockResult = this.resultCombine(txn, r1, r2);
            return lockResult;
        }
        finally {
            this.mSecond.link(Transaction.BOGUS);
        }
    }

    private LockResult lockOrLoad(Combiner combiner, Cursor from) throws IOException {
        return this.autoload() || combiner.requireValues() ? from.load() : from.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LockResult selectCombine(Transaction txn, byte[] key) throws IOException {
        byte[] value;
        byte[] v2;
        LockResult r2;
        byte[] v1;
        LockResult r1;
        this.mKey = key;
        this.mValue = Cursor.NOT_LOADED;
        Combiner combiner = this.mView.mCombiner;
        this.mFirst.link(txn);
        try {
            r1 = this.lockOrLoad(combiner, this.mFirst);
            v1 = this.mFirst.value();
        }
        finally {
            this.mFirst.link(Transaction.BOGUS);
        }
        this.mSecond.link(txn);
        try {
            r2 = this.lockOrLoad(combiner, this.mSecond);
            v2 = this.mSecond.value();
        }
        finally {
            this.mSecond.link(Transaction.BOGUS);
        }
        if (v1 == null) {
            value = v2;
        } else {
            if (v2 == null) {
                byte[] value2 = v1;
                this.mValue = value2;
                return this.resultCombine(txn, r1, r2);
            }
            value = this.mView.mCombiner.combine(key, v1, v2);
        }
        this.mValue = value;
        if (value != null) return this.resultCombine(txn, r1, r2);
        if (r1.isAcquired()) {
            txn.unlock();
        }
        if (!r2.isAcquired()) return null;
        txn.unlock();
        return null;
    }

    private LockResult resultCombine(Transaction txn, LockResult r1, LockResult r2) {
        if (r1.isAcquired()) {
            if (r1 == r2) {
                txn.unlockCombine();
            }
            return r1;
        }
        if (r2.isAcquired()) {
            return r2;
        }
        return ViewUtils.commonOwned(r1, r2);
    }

    protected abstract MergeCursor newCursor(Cursor var1, Cursor var2);

    protected abstract LockResult select(Transaction var1) throws IOException;

    protected abstract void doStore(byte[] var1, byte[] var2) throws IOException;

    protected ViewConstraintException storeFail() {
        return new ViewConstraintException("Cannot separate value for " + this.mView.type() + " view");
    }

    @FunctionalInterface
    static interface Action {
        public LockResult perform(Transaction var1) throws IOException;
    }

    @FunctionalInterface
    static interface KeyAction {
        public void perform(Cursor var1, byte[] var2) throws IOException;
    }
}

