/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Combiner;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.views.MergeCursor;
import org.cojen.tupl.views.ViewUtils;

abstract class MergeView
implements View {
    final Combiner mCombiner;
    final Ordering mOrdering;
    final Comparator<byte[]> mComparator;
    final View mFirst;
    final View mSecond;

    MergeView(Combiner combiner, View first, View second) {
        Comparator<byte[]> comparator;
        Ordering ordering = first.ordering();
        if (second.ordering() != ordering) {
            ordering = Ordering.UNSPECIFIED;
        }
        if ((comparator = first.comparator()) == null || !comparator.equals(second.comparator())) {
            throw new IllegalArgumentException("Consistent comparator ordering is required for " + this.type() + " view");
        }
        this.mCombiner = combiner;
        this.mOrdering = ordering;
        this.mComparator = comparator;
        this.mFirst = first;
        this.mSecond = second;
    }

    @Override
    public Ordering ordering() {
        return this.mOrdering;
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mComparator;
    }

    @Override
    public MergeCursor newCursor(Transaction txn) {
        Cursor first = this.mFirst.newCursor(Transaction.BOGUS);
        first.autoload(false);
        Cursor second = this.mSecond.newCursor(Transaction.BOGUS);
        second.autoload(false);
        return this.newCursor(txn, this, first, second);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mFirst.newTransaction(durabilityMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        block5: {
            block7: {
                block6: {
                    if (!this.mCombiner.combineLocks()) break block5;
                    if (txn != null) break block6;
                    txn = this.newTransaction(null);
                    break block7;
                }
                if (txn.lockMode() != LockMode.READ_COMMITTED) break block5;
                txn.enter();
            }
            try {
                txn.lockMode(LockMode.REPEATABLE_READ);
                byte[] byArray = this.doLoad(txn, key);
                return byArray;
            }
            finally {
                txn.exit();
            }
        }
        return this.doLoad(txn, key);
    }

    protected abstract byte[] doLoad(Transaction var1, byte[] var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        if (this.mCombiner.combineLocks()) {
            if (txn == null) {
                txn = this.newTransaction(null);
                try {
                    txn.lockMode(LockMode.REPEATABLE_READ);
                    this.doTouch(txn, key);
                }
                finally {
                    try {
                        txn.reset();
                    }
                    catch (IOException iOException) {}
                }
                return LockResult.UNOWNED;
            }
            if (txn.lockMode() == LockMode.READ_COMMITTED) {
                LockResult result;
                LockMode original = txn.lockMode();
                try {
                    txn.lockMode(LockMode.REPEATABLE_READ);
                    result = this.doTouch(txn, key);
                    if (result.isAcquired()) {
                        txn.unlock();
                        result = LockResult.UNOWNED;
                    }
                }
                finally {
                    txn.lockMode(original);
                }
                return result;
            }
        }
        return this.doTouch(txn, key);
    }

    private LockResult doTouch(Transaction txn, byte[] key) throws LockFailureException {
        LockResult r2;
        LockResult r1 = this.mFirst.touch(txn, key);
        try {
            r2 = this.mSecond.touch(txn, key);
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, r1);
        }
        return MergeView.lockCombine(txn, r1, r2);
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        LockResult r2;
        LockResult r1 = this.mFirst.lockShared(txn, key);
        try {
            r2 = this.mSecond.lockShared(txn, key);
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, r1);
        }
        return MergeView.lockCombine(txn, r1, r2);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        LockResult r2;
        LockResult r1 = this.mFirst.lockUpgradable(txn, key);
        try {
            r2 = this.mSecond.lockUpgradable(txn, key);
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, r1);
        }
        return MergeView.lockCombine(txn, r1, r2);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        LockResult r2;
        LockResult r1 = this.mFirst.lockExclusive(txn, key);
        try {
            r2 = this.mSecond.lockExclusive(txn, key);
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, r1);
        }
        return MergeView.lockCombine(txn, r1, r2);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        LockResult r1 = this.mFirst.lockCheck(txn, key);
        if (r1 == LockResult.UNOWNED) {
            return r1;
        }
        LockResult r2 = this.mSecond.lockCheck(txn, key);
        return r2 == LockResult.UNOWNED ? r2 : ViewUtils.commonOwned(r1, r2);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mFirst.isUnmodifiable() && this.mSecond.isUnmodifiable();
    }

    private static LockResult lockCombine(Transaction txn, LockResult r1, LockResult r2) {
        if (r2.isAcquired()) {
            if (r1 == r2) {
                txn.unlockCombine();
            }
            return r2;
        }
        return r1.isAcquired() ? r1 : ViewUtils.commonOwned(r1, r2);
    }

    protected abstract MergeCursor newCursor(Transaction var1, MergeView var2, Cursor var3, Cursor var4);

    protected abstract String type();
}

