/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;

final class ReverseCursor
implements Cursor {
    private final Cursor mSource;

    ReverseCursor(Cursor source) {
        this.mSource = source;
    }

    @Override
    public long valueLength() throws IOException {
        return this.mSource.valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        this.mSource.valueLength(length);
    }

    @Override
    public int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        return this.mSource.valueRead(pos, buf, off, len);
    }

    @Override
    public void valueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        this.mSource.valueWrite(pos, buf, off, len);
    }

    @Override
    public void valueClear(long pos, long length) throws IOException {
        this.mSource.valueClear(pos, length);
    }

    @Override
    public InputStream newValueInputStream(long pos) throws IOException {
        return this.mSource.newValueInputStream(pos);
    }

    @Override
    public InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueInputStream(pos, bufferSize);
    }

    @Override
    public OutputStream newValueOutputStream(long pos) throws IOException {
        return this.mSource.newValueOutputStream(pos);
    }

    @Override
    public OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueOutputStream(pos, bufferSize);
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering().reverse();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator().reversed();
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        return this.mSource.key();
    }

    @Override
    public byte[] value() {
        return this.mSource.value();
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return -this.mSource.compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return -this.mSource.compareKeyTo(rkey, offset, length);
    }

    @Override
    public boolean register() throws IOException {
        return this.mSource.register();
    }

    @Override
    public void unregister() {
        this.mSource.unregister();
    }

    @Override
    public LockResult first() throws IOException {
        return this.mSource.last();
    }

    @Override
    public LockResult last() throws IOException {
        return this.mSource.first();
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        if (amount == Long.MIN_VALUE) {
            LockResult result = this.mSource.skip(Long.MAX_VALUE);
            if (this.mSource.key() == null) {
                return result;
            }
            return this.next();
        }
        return this.mSource.skip(-amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == Long.MIN_VALUE) {
            LockResult result = this.mSource.skip(Long.MAX_VALUE, limitKey, inclusive);
            if (this.mSource.key() == null) {
                return result;
            }
            return this.next();
        }
        return this.mSource.skip(-amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        return this.mSource.previous();
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        return this.mSource.previousGe(limitKey);
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        return this.mSource.previousGt(limitKey);
    }

    @Override
    public LockResult previous() throws IOException {
        return this.mSource.next();
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        return this.mSource.nextLe(limitKey);
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        return this.mSource.nextLt(limitKey);
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        return this.mSource.find(key);
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        return this.mSource.findLe(key);
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        return this.mSource.findLt(key);
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        return this.mSource.findGe(key);
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        return this.mSource.findGt(key);
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        return this.mSource.findNearby(key);
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        return this.mSource.findNearbyGe(key);
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        return this.mSource.findNearbyGt(key);
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        return this.mSource.findNearbyLe(key);
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        return this.mSource.findNearbyLt(key);
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mSource.random(highKey, highInclusive, lowKey, lowInclusive);
    }

    @Override
    public boolean exists() throws IOException {
        return this.mSource.exists();
    }

    @Override
    public LockResult lock() throws IOException {
        return this.mSource.lock();
    }

    @Override
    public LockResult load() throws IOException {
        return this.mSource.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.mSource.store(value);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.mSource.commit(value);
    }

    @Override
    public Cursor copy() {
        return new ReverseCursor(this.mSource.copy());
    }

    @Override
    public void reset() {
        this.mSource.reset();
    }

    @Override
    public void close() throws IOException {
        this.mSource.close();
    }
}

