/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.views.ReverseCursor;
import org.cojen.tupl.views.UnmodifiableView;

public final class ReverseView
implements View {
    private final View mSource;

    public ReverseView(View source) {
        this.mSource = source;
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering().reverse();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator().reversed();
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new ReverseCursor(this.mSource.newCursor(txn));
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mSource.count(highKey, highInclusive, lowKey, lowInclusive);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.mSource.load(txn, key);
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.mSource.exists(txn, key);
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        this.mSource.store(txn, key, value);
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.exchange(txn, key, value);
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.insert(txn, key, value);
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.replace(txn, key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.update(txn, key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        return this.mSource.update(txn, key, oldValue, newValue);
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.mSource.delete(txn, key);
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.remove(txn, key, value);
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.mSource.touch(txn, key);
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockShared(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockShared(txn, key);
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockUpgradable(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockUpgradable(txn, key);
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockExclusive(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockExclusive(txn, key);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mSource.lockCheck(txn, key);
    }

    @Override
    public View viewGe(byte[] key) {
        return new ReverseView(this.mSource.viewLe(key));
    }

    @Override
    public View viewGt(byte[] key) {
        return new ReverseView(this.mSource.viewLt(key));
    }

    @Override
    public View viewLe(byte[] key) {
        return new ReverseView(this.mSource.viewGe(key));
    }

    @Override
    public View viewLt(byte[] key) {
        return new ReverseView(this.mSource.viewGt(key));
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        return new ReverseView(this.mSource.viewPrefix(prefix, trim));
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return new ReverseView(this.mSource.viewTransformed(transformer));
    }

    @Override
    public View viewKeys() {
        View sourceKeys = this.mSource.viewKeys();
        return sourceKeys == this.mSource ? this : new ReverseView(sourceKeys);
    }

    @Override
    public View viewReverse() {
        return this.mSource;
    }

    @Override
    public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mSource.isModifyAtomic();
    }
}

