/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import org.cojen.tupl.Combiner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;

public abstract class SelectCombiner
implements Combiner {
    @Override
    public boolean requireValues() {
        return false;
    }

    public static final class Discard
    extends SelectCombiner {
        public static final Combiner THE = new Discard();

        @Override
        public byte[] combine(byte[] key, byte[] first, byte[] second) {
            return null;
        }

        @Override
        public byte[] loadUnion(Transaction txn, byte[] key, View first, View second) throws IOException {
            byte[] v1 = first.load(txn, key);
            if (v1 == null) {
                return second.load(txn, key);
            }
            return second.exists(txn, key) ? null : v1;
        }

        @Override
        public byte[] loadIntersection(Transaction txn, byte[] key, View first, View second) throws IOException {
            first.touch(txn, key);
            second.touch(txn, key);
            return null;
        }

        @Override
        public byte[] loadDifference(Transaction txn, byte[] key, View first, View second) throws IOException {
            byte[] v1 = first.load(txn, key);
            if (v1 == null) {
                second.touch(txn, key);
                return null;
            }
            return second.exists(txn, key) ? null : v1;
        }
    }

    public static final class Second
    extends SelectCombiner {
        public static final Combiner THE = new Second();

        @Override
        public byte[] combine(byte[] key, byte[] first, byte[] second) {
            return second;
        }

        @Override
        public byte[] loadUnion(Transaction txn, byte[] key, View first, View second) throws IOException {
            first.touch(txn, key);
            byte[] v2 = second.load(txn, key);
            return v2 == null ? first.load(txn, key) : v2;
        }

        @Override
        public byte[] loadIntersection(Transaction txn, byte[] key, View first, View second) throws IOException {
            first.touch(txn, key);
            byte[] v2 = second.load(txn, key);
            return v2 == null ? null : (byte[])(first.exists(txn, key) ? v2 : null);
        }
    }

    public static final class First
    extends SelectCombiner {
        public static final Combiner THE = new First();

        @Override
        public byte[] combine(byte[] key, byte[] first, byte[] second) {
            return first;
        }

        @Override
        public byte[] loadUnion(Transaction txn, byte[] key, View first, View second) throws IOException {
            byte[] v1 = first.load(txn, key);
            if (v1 == null) {
                return second.load(txn, key);
            }
            second.touch(txn, key);
            return v1;
        }

        @Override
        public byte[] loadIntersection(Transaction txn, byte[] key, View first, View second) throws IOException {
            byte[] v1 = first.load(txn, key);
            if (v1 == null) {
                second.touch(txn, key);
                return null;
            }
            return (byte[])(second.exists(txn, key) ? v1 : null);
        }

        @Override
        public byte[] loadDifference(Transaction txn, byte[] key, View first, View second) throws IOException {
            byte[] v1 = first.load(txn, key);
            if (v1 == null) {
                second.touch(txn, key);
                return null;
            }
            return v1;
        }
    }
}

