/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;

abstract class SubView
implements View {
    final View mSource;

    SubView(View source) {
        this.mSource = source;
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.inRange(key) ? this.mSource.load(txn, key) : null;
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.inRange(key) && this.mSource.exists(txn, key);
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            this.mSource.store(txn, key, value);
        } else if (value != null) {
            throw SubView.fail();
        }
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.exchange(txn, key, value);
        }
        if (value == null) {
            return null;
        }
        throw SubView.fail();
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.insert(txn, key, value);
        }
        if (value == null) {
            return true;
        }
        throw SubView.fail();
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.inRange(key) && this.mSource.replace(txn, key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.update(txn, key, value);
        }
        if (value != null) {
            throw SubView.fail();
        }
        return false;
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        if (this.inRange(key)) {
            return this.mSource.update(txn, key, oldValue, newValue);
        }
        if (oldValue == null) {
            if (newValue == null) {
                return true;
            }
            throw SubView.fail();
        }
        return false;
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.inRange(key) && this.mSource.delete(txn, key);
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.inRange(key) ? this.mSource.remove(txn, key, value) : value == null;
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.inRange(key) ? this.mSource.touch(txn, key) : LockResult.UNOWNED;
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.tryLockShared(txn, key, nanosTimeout);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockShared(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.tryLockUpgradable(txn, key, nanosTimeout);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockUpgradable(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.tryLockExclusive(txn, key, nanosTimeout);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockExclusive(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        if (this.inRange(key)) {
            return this.mSource.lockCheck(txn, key);
        }
        throw SubView.fail();
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mSource.isModifyAtomic();
    }

    abstract boolean inRange(byte[] var1);

    static void prefixCheck(byte[] prefix, int trim) {
        if (prefix == null) {
            throw new NullPointerException("Prefix is null");
        }
        if (trim < 0 | trim > prefix.length) {
            if (trim < 0) {
                throw new IllegalArgumentException("Negative trim");
            }
            throw new IllegalArgumentException("Trim amount is longer than prefix");
        }
    }

    static ViewConstraintException fail() {
        return new ViewConstraintException("Key is outside allowed range");
    }
}

