/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.core.CoreValueAccessor;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.views.TransformedView;
import org.cojen.tupl.views.ViewUtils;

public final class TransformedCursor
extends CoreValueAccessor
implements Cursor {
    private final Cursor mSource;
    private final Transformer mTransformer;
    private byte[] mKey;
    private byte[] mValue;

    TransformedCursor(Cursor source, Transformer transformer) {
        this.mSource = source;
        this.mTransformer = transformer;
    }

    @Override
    public Ordering ordering() {
        return this.mTransformer.transformedOrdering(this.mSource.ordering());
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mTransformer.transformedComparator(this.mSource.comparator());
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        return this.mKey;
    }

    @Override
    public byte[] value() {
        return this.mValue;
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mSource.compareKeyTo(this.mTransformer.inverseTransformKey(rkey));
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        if (offset != 0 || length != rkey.length) {
            byte[] newRkey = new byte[length];
            System.arraycopy(rkey, offset, newRkey, 0, length);
            rkey = newRkey;
        }
        return this.mSource.compareKeyTo(this.mTransformer.inverseTransformKey(rkey));
    }

    @Override
    public boolean register() throws IOException {
        return this.mSource.register();
    }

    @Override
    public void unregister() {
        this.mSource.unregister();
    }

    @Override
    public LockResult first() throws IOException {
        LockResult result;
        try {
            result = this.mSource.first();
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.next() : result;
    }

    @Override
    public LockResult last() throws IOException {
        LockResult result;
        try {
            result = this.mSource.last();
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.previous() : result;
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        return amount == 0L ? this.mSource.skip(0L) : ViewUtils.skipWithLocks(this, amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return ViewUtils.skipWithLocks(this, amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        do {
            try {
                result = c.next();
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult nextLe(byte[] limitTKey) throws IOException {
        LockResult result;
        byte[] limitKey = this.inverseTransformKey(limitTKey);
        if (limitKey == null && (limitKey = this.mTransformer.inverseTransformKeyLt(limitTKey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        Cursor c = this.mSource;
        do {
            try {
                result = c.nextLe(limitKey);
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult nextLt(byte[] limitTKey) throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        byte[] limitKey = this.inverseTransformKey(limitTKey);
        if (limitKey == null) {
            LockResult result2;
            limitKey = this.mTransformer.inverseTransformKeyLt(limitTKey);
            if (limitKey == null) {
                this.reset();
                return LockResult.UNOWNED;
            }
            do {
                try {
                    result2 = c.nextLe(limitKey);
                }
                catch (LockFailureException e) {
                    throw this.transformCurrent(e);
                }
            } while ((result2 = this.transformCurrent(result2)) == null);
            return result2;
        }
        do {
            try {
                result = c.nextLt(limitKey);
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult previous() throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        do {
            try {
                result = c.previous();
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult previousGe(byte[] limitTKey) throws IOException {
        LockResult result;
        byte[] limitKey = this.inverseTransformKey(limitTKey);
        if (limitKey == null && (limitKey = this.mTransformer.inverseTransformKeyGt(limitTKey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        Cursor c = this.mSource;
        do {
            try {
                result = c.previousGe(limitKey);
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult previousGt(byte[] limitTKey) throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        byte[] limitKey = this.inverseTransformKey(limitTKey);
        if (limitKey == null) {
            LockResult result2;
            limitKey = this.mTransformer.inverseTransformKeyGt(limitTKey);
            if (limitKey == null) {
                this.reset();
                return LockResult.UNOWNED;
            }
            do {
                try {
                    result2 = c.previousGe(limitKey);
                }
                catch (LockFailureException e) {
                    throw this.transformCurrent(e);
                }
            } while ((result2 = this.transformCurrent(result2)) == null);
            return result2;
        }
        do {
            try {
                result = c.previousGt(limitKey);
            }
            catch (LockFailureException e) {
                throw this.transformCurrent(e);
            }
        } while ((result = this.transformCurrent(result)) == null);
        return result;
    }

    @Override
    public LockResult find(byte[] tkey) throws IOException {
        this.mKey = tkey;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            this.mValue = null;
            this.mSource.reset();
            return LockResult.UNOWNED;
        }
        this.mValue = NOT_LOADED;
        return this.transformCurrent(this.mSource.find(key), tkey);
    }

    @Override
    public LockResult findGe(byte[] tkey) throws IOException {
        LockResult result;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyGt(tkey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        try {
            result = this.mSource.findGe(key);
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.next() : result;
    }

    @Override
    public LockResult findGt(byte[] tkey) throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        try {
            byte[] key = this.inverseTransformKey(tkey);
            if (key == null) {
                key = this.mTransformer.inverseTransformKeyGt(tkey);
                if (key == null) {
                    this.reset();
                    return LockResult.UNOWNED;
                }
                result = c.findGe(key);
            } else {
                result = c.findGt(key);
            }
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.next() : result;
    }

    @Override
    public LockResult findLe(byte[] tkey) throws IOException {
        LockResult result;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyLt(tkey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        try {
            result = this.mSource.findLe(key);
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.previous() : result;
    }

    @Override
    public LockResult findLt(byte[] tkey) throws IOException {
        LockResult result;
        Cursor c = this.mSource;
        try {
            byte[] key = this.inverseTransformKey(tkey);
            if (key == null) {
                key = this.mTransformer.inverseTransformKeyLt(tkey);
                if (key == null) {
                    this.reset();
                    return LockResult.UNOWNED;
                }
                result = c.findLe(key);
            } else {
                result = c.findLt(key);
            }
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        return result == null ? this.previous() : result;
    }

    @Override
    public LockResult findNearby(byte[] tkey) throws IOException {
        this.mKey = tkey;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            this.mValue = null;
            this.mSource.reset();
            return LockResult.UNOWNED;
        }
        this.mValue = NOT_LOADED;
        return this.transformCurrent(this.mSource.findNearby(key), tkey);
    }

    @Override
    public LockResult random(byte[] lowTKey, boolean lowInclusive, byte[] highTKey, boolean highInclusive) throws IOException {
        LockResult result;
        byte[] lowKey = null;
        if (lowTKey != null && (lowKey = this.mTransformer.inverseTransformKey(lowTKey)) == null && (lowKey = this.mTransformer.inverseTransformKeyGt(lowTKey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        byte[] highKey = null;
        if (highTKey != null && (highKey = this.mTransformer.inverseTransformKey(highTKey)) == null && (highKey = this.mTransformer.inverseTransformKeyLt(highTKey)) == null) {
            this.reset();
            return LockResult.UNOWNED;
        }
        try {
            result = this.mSource.random(lowKey, lowInclusive, highKey, highInclusive);
        }
        catch (LockFailureException e) {
            throw this.transformCurrent(e);
        }
        result = this.transformCurrent(result);
        if (result == null) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                result = this.next();
                if (this.mKey == null) {
                    result = this.first();
                }
            } else {
                result = this.previous();
                if (this.mKey == null) {
                    result = this.last();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws IOException {
        byte[] oValue = this.mValue;
        Transaction oTxn = this.link(Transaction.BOGUS);
        try {
            this.load();
            boolean bl = this.mValue != null;
            return bl;
        }
        finally {
            this.link(oTxn);
            this.mValue = oValue;
        }
    }

    @Override
    public LockResult lock() throws IOException {
        LockResult result;
        byte[] tkey = this.mKey;
        ViewUtils.positionCheck(tkey);
        if (this.mSource.key() == null) {
            throw TransformedView.fail();
        }
        byte[] value = this.mSource.value();
        try {
            result = this.mSource.lock();
        }
        catch (IOException e) {
            this.mValue = NOT_LOADED;
            throw e;
        }
        if (value == this.mSource.value()) {
            return result;
        }
        this.mValue = NOT_LOADED;
        return this.transformCurrent(result, tkey);
    }

    @Override
    public LockResult load() throws IOException {
        byte[] tkey = this.mKey;
        ViewUtils.positionCheck(tkey);
        if (this.mSource.key() == null) {
            throw TransformedView.fail();
        }
        this.mValue = NOT_LOADED;
        return this.transformCurrent(this.mSource.load(), tkey);
    }

    @Override
    public void store(byte[] tvalue) throws IOException {
        byte[] tkey = this.mKey;
        ViewUtils.positionCheck(tkey);
        Cursor c = this.mSource;
        byte[] key = c.key();
        if (key == null) {
            throw TransformedView.fail();
        }
        c.store(this.mTransformer.inverseTransformValue(tvalue, key, tkey));
        this.mValue = tvalue;
    }

    @Override
    public void commit(byte[] tvalue) throws IOException {
        byte[] tkey = this.mKey;
        ViewUtils.positionCheck(tkey);
        Cursor c = this.mSource;
        byte[] key = c.key();
        if (key == null) {
            throw TransformedView.fail();
        }
        c.commit(this.mTransformer.inverseTransformValue(tvalue, key, tkey));
        this.mValue = tvalue;
    }

    @Override
    public Cursor copy() {
        TransformedCursor copy = new TransformedCursor(this.mSource.copy(), this.mTransformer);
        copy.mKey = Utils.cloneArray(this.mKey);
        copy.mValue = ViewUtils.copyValue(this.mValue);
        return copy;
    }

    @Override
    public void reset() {
        this.mKey = null;
        this.mValue = null;
        this.mSource.reset();
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public long valueLength() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void valueLength(long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int doValueRead(long pos, byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doValueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doValueClear(long pos, long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int valueStreamBufferSize(int bufferSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void valueCheckOpen() {
        throw new UnsupportedOperationException();
    }

    private byte[] inverseTransformKey(byte[] tkey) {
        Utils.keyCheck(tkey);
        return this.mTransformer.inverseTransformKey(tkey);
    }

    private LockFailureException transformCurrent(LockFailureException e) throws IOException {
        this.mValue = NOT_LOADED;
        try {
            this.mKey = this.mTransformer.transformKey(this.mSource);
        }
        catch (Throwable e2) {
            this.reset();
            throw e2;
        }
        return e;
    }

    private LockResult transformCurrent(LockResult result) throws IOException {
        Cursor c = this.mSource;
        byte[] key = c.key();
        if (key == null) {
            this.mKey = null;
            this.mValue = null;
            return LockResult.UNOWNED;
        }
        byte[] tkey = this.mTransformer.transformKey(c);
        this.mKey = tkey;
        if (c.value() == null) {
            this.mValue = null;
            if (tkey != null) {
                return result;
            }
        } else {
            byte[] tvalue;
            if (tkey != null && (tvalue = this.mTransformer.transformValue(c, tkey)) != null) {
                this.mValue = tvalue;
                return result;
            }
            this.mValue = null;
        }
        if (result == LockResult.ACQUIRED) {
            c.link().unlock();
        }
        return null;
    }

    private LockResult transformCurrent(LockResult result, byte[] tkey) throws IOException {
        Cursor c = this.mSource;
        if (c.value() == null) {
            this.mValue = null;
            return result;
        }
        byte[] tvalue = this.mTransformer.transformValue(c, tkey);
        this.mValue = tvalue;
        if (tvalue == null && result == LockResult.ACQUIRED) {
            c.link().unlock();
            result = LockResult.UNOWNED;
        }
        return result;
    }

    public Cursor source() {
        return this.mSource;
    }
}

