/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.views.BoundedView;
import org.cojen.tupl.views.ReverseView;
import org.cojen.tupl.views.SubView;
import org.cojen.tupl.views.TransformedCursor;
import org.cojen.tupl.views.TrimmedView;
import org.cojen.tupl.views.UnmodifiableView;
import org.cojen.tupl.views.ViewUtils;

public final class TransformedView
implements View {
    private final View mSource;
    private final Transformer mTransformer;

    public static View apply(View source, Transformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("Transformer is null");
        }
        return new TransformedView(source, transformer);
    }

    private TransformedView(View source, Transformer transformer) {
        this.mSource = source;
        this.mTransformer = transformer;
    }

    @Override
    public Ordering ordering() {
        return this.mTransformer.transformedOrdering(this.mSource.ordering());
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mTransformer.transformedComparator(this.mSource.comparator());
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new TransformedCursor(this.mSource.newCursor(txn), this.mTransformer);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return ViewUtils.count(this, this.mTransformer.requireValue() == Boolean.TRUE, lowKey, true, highKey, 0);
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return ViewUtils.count(this, this.mTransformer.requireValue() == Boolean.TRUE, lowKey, lowInclusive, highKey, highInclusive ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Transaction txn, byte[] tkey) throws IOException {
        if (this.mTransformer.requireValue() == null) {
            Cursor c = this.newCursor(txn);
            try {
                c.autoload(false);
                c.find(tkey);
                byte[] value = c.value();
                if (value == Cursor.NOT_LOADED) {
                    c.load();
                    value = c.value();
                }
                byte[] byArray = value;
                return byArray;
            }
            finally {
                c.reset();
            }
        }
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return null;
        }
        if (txn == null || !txn.lockMode().isRepeatable()) {
            return this.mTransformer.transformValue(this.mSource.load(txn, key), key, tkey);
        }
        LockResult result = this.mSource.touch(txn, key);
        try {
            byte[] value = this.mSource.load(txn, key);
            if (value != null && (value = this.mTransformer.transformValue(value, key, tkey)) == null && result == LockResult.ACQUIRED) {
                txn.unlock();
            }
            return value;
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Transaction txn, byte[] tkey) throws IOException {
        Boolean requireValue = this.mTransformer.requireValue();
        if (requireValue == null) {
            Cursor c = this.newCursor(txn);
            try {
                c.autoload(false);
                c.find(tkey);
                boolean bl = c.value() != null;
                return bl;
            }
            finally {
                c.reset();
            }
        }
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return false;
        }
        if (requireValue == Boolean.FALSE) {
            return this.mSource.exists(txn, key);
        }
        if (txn == null || !txn.lockMode().isRepeatable()) {
            return this.mTransformer.transformValue(this.mSource.load(txn, key), key, tkey) != null;
        }
        LockResult result = this.mSource.touch(txn, key);
        try {
            byte[] value = this.mSource.load(txn, key);
            if (value != null && (value = this.mTransformer.transformValue(value, key, tkey)) == null && result == LockResult.ACQUIRED) {
                txn.unlock();
            }
            return value != null;
        }
        catch (Throwable e) {
            throw ViewUtils.lockCleanup(e, txn, result);
        }
    }

    @Override
    public void store(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (tvalue == null) {
                return;
            }
            throw TransformedView.fail();
        }
        this.mSource.store(txn, key, this.mTransformer.inverseTransformValue(tvalue, key, tkey));
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (tvalue == null) {
                return null;
            }
            throw TransformedView.fail();
        }
        return this.mTransformer.transformValue(this.mSource.exchange(txn, key, this.mTransformer.inverseTransformValue(tvalue, key, tkey)), key, tkey);
    }

    @Override
    public boolean replace(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            return false;
        }
        byte[] value = this.mTransformer.inverseTransformValue(tvalue, key, tkey);
        if (value == null) {
            return this.mSource.delete(txn, key);
        }
        if (tvalue != null) {
            return this.mSource.replace(txn, key, value);
        }
        return this.mSource.update(txn, key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] tkey, byte[] tvalue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (tvalue != null) {
                return false;
            }
            throw TransformedView.fail();
        }
        byte[] value = this.mTransformer.inverseTransformValue(tvalue, key, tkey);
        return this.mSource.update(txn, key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] tkey, byte[] oldTValue, byte[] newTValue) throws IOException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            if (oldTValue == null) {
                if (newTValue == null) {
                    return true;
                }
                throw TransformedView.fail();
            }
            return false;
        }
        byte[] oldValue = this.mTransformer.inverseTransformValue(oldTValue, key, tkey);
        byte[] newValue = this.mTransformer.inverseTransformValue(newTValue, key, tkey);
        return this.mSource.update(txn, key, oldValue, newValue);
    }

    @Override
    public LockResult touch(Transaction txn, byte[] tkey) throws LockFailureException {
        byte[] key = this.inverseTransformKey(tkey);
        return key == null ? LockResult.UNOWNED : this.mSource.touch(txn, key);
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] tkey, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.tryLockShared(txn, key, nanosTimeout);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockShared(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] tkey, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.tryLockUpgradable(txn, key, nanosTimeout);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockUpgradable(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] tkey, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.tryLockExclusive(txn, key, nanosTimeout);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] tkey) throws LockFailureException, ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockExclusive(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] tkey) throws ViewConstraintException {
        byte[] key = this.inverseTransformKey(tkey);
        if (key != null) {
            return this.mSource.lockCheck(txn, key);
        }
        throw TransformedView.fail();
    }

    @Override
    public View viewGe(byte[] tkey) {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyGt(tkey)) == null) {
            return this.nonView();
        }
        return new TransformedView(this.mSource.viewGe(key), this.mTransformer);
    }

    @Override
    public View viewGt(byte[] tkey) {
        View subView;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            key = this.mTransformer.inverseTransformKeyGt(tkey);
            if (key == null) {
                return this.nonView();
            }
            subView = this.mSource.viewGe(key);
        } else {
            subView = this.mSource.viewGt(key);
        }
        return new TransformedView(subView, this.mTransformer);
    }

    @Override
    public View viewLe(byte[] tkey) {
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null && (key = this.mTransformer.inverseTransformKeyLt(tkey)) == null) {
            return this.nonView();
        }
        return new TransformedView(this.mSource.viewLe(key), this.mTransformer);
    }

    @Override
    public View viewLt(byte[] tkey) {
        View subView;
        byte[] key = this.inverseTransformKey(tkey);
        if (key == null) {
            key = this.mTransformer.inverseTransformKeyLt(tkey);
            if (key == null) {
                return this.nonView();
            }
            subView = this.mSource.viewLe(key);
        } else {
            subView = this.mSource.viewLt(key);
        }
        return new TransformedView(subView, this.mTransformer);
    }

    @Override
    public View viewPrefix(byte[] tprefix, int trim) {
        byte[] key;
        SubView.prefixCheck(tprefix, trim);
        byte[] lowKey = key = this.inverseTransformKey(tprefix);
        if (lowKey == null && (lowKey = this.mTransformer.inverseTransformKeyGt(tprefix)) == null) {
            return this.nonView();
        }
        View subView = this.mSource.viewGe(lowKey);
        byte[] highTKey = (byte[])tprefix.clone();
        if (Utils.increment(highTKey, 0, highTKey.length)) {
            byte[] highKey = this.inverseTransformKey(highTKey);
            if (highKey == null) {
                highKey = this.mTransformer.inverseTransformKeyLt(highTKey);
                if (highKey == null) {
                    return this.nonView();
                }
                subView = subView.viewLe(highKey);
            } else {
                subView = subView.viewLt(highKey);
            }
        }
        View view = new TransformedView(subView, this.mTransformer);
        if (trim > 0) {
            view = new TrimmedView(view, tprefix, trim);
        }
        return view;
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    @Override
    public View viewReverse() {
        return new ReverseView(this);
    }

    @Override
    public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mSource.isModifyAtomic();
    }

    private byte[] inverseTransformKey(byte[] tkey) {
        Utils.keyCheck(tkey);
        return this.mTransformer.inverseTransformKey(tkey);
    }

    private View nonView() {
        return new TransformedView(new BoundedView(this.mSource, Utils.EMPTY_BYTES, Utils.EMPTY_BYTES, -1), this.mTransformer);
    }

    static ViewConstraintException fail() {
        return new ViewConstraintException("Unsupported key");
    }
}

