/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.views.TrimmedView;

final class TrimmedCursor
implements Cursor {
    private final TrimmedView mView;
    private final Cursor mSource;
    private final int mTrim;
    private byte[] mKey;

    TrimmedCursor(TrimmedView view, Cursor source) {
        this.mView = view;
        this.mSource = source;
        this.mTrim = view.mTrim;
    }

    @Override
    public long valueLength() throws IOException {
        return this.mSource.valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        this.mSource.valueLength(length);
    }

    @Override
    public int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        return this.mSource.valueRead(pos, buf, off, len);
    }

    @Override
    public void valueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        this.mSource.valueWrite(pos, buf, off, len);
    }

    @Override
    public void valueClear(long pos, long length) throws IOException {
        this.mSource.valueClear(pos, length);
    }

    @Override
    public InputStream newValueInputStream(long pos) throws IOException {
        return this.mSource.newValueInputStream(pos);
    }

    @Override
    public InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueInputStream(pos, bufferSize);
    }

    @Override
    public OutputStream newValueOutputStream(long pos) throws IOException {
        return this.mSource.newValueOutputStream(pos);
    }

    @Override
    public OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        return this.mSource.newValueOutputStream(pos, bufferSize);
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public Transaction link(Transaction txn) {
        return this.mSource.link(txn);
    }

    @Override
    public Transaction link() {
        return this.mSource.link();
    }

    @Override
    public byte[] key() {
        byte[] full;
        byte[] key = this.mKey;
        if (key == null && (full = this.mSource.key()) != null) {
            int trim = this.mTrim;
            int len = full.length - trim;
            key = new byte[len];
            System.arraycopy(full, trim, key, 0, len);
            this.mKey = key;
        }
        return key;
    }

    @Override
    public byte[] value() {
        return this.mSource.value();
    }

    @Override
    public boolean autoload(boolean mode) {
        return this.mSource.autoload(mode);
    }

    @Override
    public boolean autoload() {
        return this.mSource.autoload();
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mSource.compareKeyTo(this.mView.applyPrefix(rkey));
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return this.mSource.compareKeyTo(this.mView.applyPrefix(rkey, offset, length));
    }

    @Override
    public boolean register() throws IOException {
        return this.mSource.register();
    }

    @Override
    public void unregister() {
        this.mSource.unregister();
    }

    @Override
    public LockResult first() throws IOException {
        this.mKey = null;
        return this.mSource.first();
    }

    @Override
    public LockResult last() throws IOException {
        this.mKey = null;
        return this.mSource.last();
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        this.mKey = null;
        return this.mSource.skip(amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        this.mKey = null;
        return this.mSource.skip(amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        this.mKey = null;
        return this.mSource.next();
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        this.mKey = null;
        return this.mSource.nextLe(this.mView.applyPrefix(limitKey));
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        this.mKey = null;
        return this.mSource.nextLt(this.mView.applyPrefix(limitKey));
    }

    @Override
    public LockResult previous() throws IOException {
        this.mKey = null;
        return this.mSource.previous();
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        this.mKey = null;
        return this.mSource.previousGe(this.mView.applyPrefix(limitKey));
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        this.mKey = null;
        return this.mSource.previousGt(this.mView.applyPrefix(limitKey));
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.find(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findGe(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findGt(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findLe(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findLt(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findNearby(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findNearbyGe(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findNearbyGt(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findNearbyLe(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        this.mKey = null;
        return this.mSource.findNearbyLt(this.mView.applyPrefix(key));
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        this.mKey = null;
        if (lowKey != null) {
            lowKey = this.mView.applyPrefix(lowKey);
        }
        if (highKey != null) {
            highKey = this.mView.applyPrefix(highKey);
        }
        return this.mSource.random(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public boolean exists() throws IOException {
        return this.mSource.exists();
    }

    @Override
    public LockResult lock() throws IOException {
        return this.mSource.lock();
    }

    @Override
    public LockResult load() throws IOException {
        return this.mSource.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.mSource.store(value);
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.mSource.commit(value);
    }

    @Override
    public Cursor copy() {
        TrimmedCursor c = new TrimmedCursor(this.mView, this.mSource.copy());
        c.mKey = this.mKey;
        return c;
    }

    @Override
    public void reset() {
        this.mKey = null;
        this.mSource.reset();
    }

    @Override
    public void close() throws IOException {
        this.mKey = null;
        this.mSource.close();
    }
}

