/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.views.SubView;
import org.cojen.tupl.views.TransformedView;
import org.cojen.tupl.views.TrimmedCursor;
import org.cojen.tupl.views.UnmodifiableView;

final class TrimmedView
implements View {
    private final View mSource;
    private final byte[] mPrefix;
    final int mTrim;

    TrimmedView(View source, byte[] prefix, int trim) {
        this.mSource = source;
        this.mPrefix = prefix;
        this.mTrim = trim;
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new TrimmedCursor(this, this.mSource.newCursor(txn));
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.count(lowKey, highKey);
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mSource.count(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.mSource.load(txn, this.applyPrefix(key));
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.mSource.exists(txn, this.applyPrefix(key));
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        this.mSource.store(txn, this.applyPrefix(key), value);
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.exchange(txn, this.applyPrefix(key), value);
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.insert(txn, this.applyPrefix(key), value);
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.replace(txn, this.applyPrefix(key), value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.update(txn, this.applyPrefix(key), value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        return this.mSource.update(txn, this.applyPrefix(key), oldValue, newValue);
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.mSource.delete(txn, this.applyPrefix(key));
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mSource.remove(txn, this.applyPrefix(key), value);
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.mSource.touch(txn, this.applyPrefix(key));
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockShared(txn, this.applyPrefix(key), nanosTimeout);
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockShared(txn, this.applyPrefix(key));
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockUpgradable(txn, this.applyPrefix(key), nanosTimeout);
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockUpgradable(txn, this.applyPrefix(key));
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockExclusive(txn, this.applyPrefix(key), nanosTimeout);
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockExclusive(txn, this.applyPrefix(key));
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mSource.lockCheck(txn, this.applyPrefix(key));
    }

    @Override
    public View viewGe(byte[] key) {
        return new TrimmedView(this.mSource.viewGe(this.applyPrefix(key)), this.mPrefix, this.mTrim);
    }

    @Override
    public View viewGt(byte[] key) {
        return new TrimmedView(this.mSource.viewGt(this.applyPrefix(key)), this.mPrefix, this.mTrim);
    }

    @Override
    public View viewLe(byte[] key) {
        return new TrimmedView(this.mSource.viewLe(this.applyPrefix(key)), this.mPrefix, this.mTrim);
    }

    @Override
    public View viewLt(byte[] key) {
        return new TrimmedView(this.mSource.viewLt(this.applyPrefix(key)), this.mPrefix, this.mTrim);
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        SubView.prefixCheck(prefix, trim);
        return this.mSource.viewPrefix(this.applyPrefix(prefix), this.mTrim + trim);
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    @Override
    public View viewKeys() {
        View sourceKeys = this.mSource.viewKeys();
        return sourceKeys == this.mSource ? this : new TrimmedView(sourceKeys, this.mPrefix, this.mTrim);
    }

    @Override
    public View viewReverse() {
        return new TrimmedView(this.mSource.viewReverse(), this.mPrefix, this.mTrim);
    }

    @Override
    public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mSource.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mSource.isModifyAtomic();
    }

    byte[] applyPrefix(byte[] key) {
        return this.applyPrefix(key, 0, key.length);
    }

    byte[] applyPrefix(byte[] key, int offset, int length) {
        Utils.keyCheck(key);
        byte[] prefix = this.mPrefix;
        byte[] full = new byte[prefix.length + length];
        System.arraycopy(prefix, 0, full, 0, prefix.length);
        System.arraycopy(key, offset, full, prefix.length, length);
        return full;
    }
}

