/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.views.MergeCursor;
import org.cojen.tupl.views.MergeView;

final class UnionCursor
extends MergeCursor {
    UnionCursor(Transaction txn, MergeView view, Cursor first, Cursor second) {
        super(txn, view, first, second);
    }

    @Override
    public boolean exists() throws IOException {
        return this.mFirst.exists() || this.mSecond.exists();
    }

    @Override
    protected MergeCursor newCursor(Cursor first, Cursor second) {
        return new UnionCursor(this.mTxn, this.mView, first, second);
    }

    @Override
    protected LockResult select(Transaction txn) throws IOException {
        int cmp;
        byte[] k1 = this.mFirst.key();
        byte[] k2 = this.mSecond.key();
        if (k1 == null) {
            if (k2 == null) {
                this.mCompare = 0;
                this.mKey = null;
                this.mValue = null;
                return LockResult.UNOWNED;
            }
            this.mCompare = 1 ^ this.mDirection;
            return this.selectSecond(txn, k2);
        }
        if (k2 == null) {
            this.mCompare = 0xFFFFFFFE ^ this.mDirection;
            return this.selectFirst(txn, k1);
        }
        this.mCompare = cmp = this.comparator().compare(k1, k2);
        if (cmp == 0) {
            return this.selectCombine(txn, k1);
        }
        if ((cmp ^ this.mDirection) < 0) {
            return this.selectFirst(txn, k1);
        }
        return this.selectSecond(txn, k2);
    }

    @Override
    protected void doStore(byte[] key, byte[] value) throws IOException {
        block3: {
            byte[] second;
            byte[] first;
            block5: {
                block4: {
                    block2: {
                        if (value != null) break block2;
                        this.mFirst.store(null);
                        this.mSecond.store(null);
                        break block3;
                    }
                    byte[][] values = this.mView.mCombiner.separate(key, value);
                    if (values == null) break block4;
                    first = values[0];
                    second = values[1];
                    if (first != null || second != null) break block5;
                }
                throw this.storeFail();
            }
            this.mFirst.store(first);
            this.mSecond.store(second);
        }
    }
}

