/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.UnmodifiableViewException;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.diag.IndexStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.views.UnmodifiableCursor;
import org.cojen.tupl.views.ViewUtils;

public final class UnmodifiableView
implements Index {
    private final View mSource;

    public static View apply(View view) {
        return view.isUnmodifiable() ? view : new UnmodifiableView(view);
    }

    public UnmodifiableView(View source) {
        this.mSource = source;
    }

    public String toString() {
        if (this.mSource instanceof Index) {
            return ViewUtils.toString(this);
        }
        return super.toString();
    }

    @Override
    public Ordering ordering() {
        return this.mSource.ordering();
    }

    @Override
    public Comparator<byte[]> comparator() {
        return this.mSource.comparator();
    }

    @Override
    public long id() {
        View view = this.mSource;
        if (view instanceof Index) {
            Index ix = (Index)view;
            return ix.id();
        }
        return 0L;
    }

    @Override
    public byte[] name() {
        View view = this.mSource;
        if (view instanceof Index) {
            Index ix = (Index)view;
            return ix.name();
        }
        return null;
    }

    @Override
    public String nameString() {
        View view = this.mSource;
        if (view instanceof Index) {
            Index ix = (Index)view;
            return ix.nameString();
        }
        return null;
    }

    @Override
    public <R> Table<R> asTable(Class<R> type) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new UnmodifiableCursor(this.mSource.newCursor(txn));
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mSource.newTransaction(durabilityMode);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mSource.count(lowKey, highKey);
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mSource.count(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.mSource.load(txn, key);
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.mSource.exists(txn, key);
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.mSource.touch(txn, key);
    }

    @Override
    public long evict(Transaction txn, byte[] lowKey, byte[] highKey, Filter evictionFilter, boolean autoload) throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockShared(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockShared(txn, key);
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockUpgradable(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockUpgradable(txn, key);
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException, ViewConstraintException {
        return this.mSource.tryLockExclusive(txn, key, nanosTimeout);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mSource.lockExclusive(txn, key);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mSource.lockCheck(txn, key);
    }

    @Override
    public View viewGe(byte[] key) {
        return UnmodifiableView.apply(this.mSource.viewGe(key));
    }

    @Override
    public View viewGt(byte[] key) {
        return UnmodifiableView.apply(this.mSource.viewGt(key));
    }

    @Override
    public View viewLe(byte[] key) {
        return UnmodifiableView.apply(this.mSource.viewLe(key));
    }

    @Override
    public View viewLt(byte[] key) {
        return UnmodifiableView.apply(this.mSource.viewLt(key));
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        return UnmodifiableView.apply(this.mSource.viewPrefix(prefix, trim));
    }

    @Override
    public View viewTransformed(Transformer transformer) {
        return UnmodifiableView.apply(this.mSource.viewTransformed(transformer));
    }

    @Override
    public View viewReverse() {
        return UnmodifiableView.apply(this.mSource.viewReverse());
    }

    @Override
    public View viewUnmodifiable() {
        return this;
    }

    @Override
    public boolean isUnmodifiable() {
        return true;
    }

    @Override
    public IndexStats analyze(byte[] lowKey, byte[] highKey) throws IOException {
        View view = this.mSource;
        if (view instanceof Index) {
            Index ix = (Index)view;
            return ix.analyze(lowKey, highKey);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verify(final VerificationObserver observer) throws IOException {
        View view = this.mSource;
        if (!(view instanceof Index)) {
            return true;
        }
        Index ix = (Index)view;
        VerificationObserver obs = null;
        if (observer != null) {
            obs = new VerificationObserver(){

                @Override
                public boolean indexBegin(Index index, int height) {
                    return observer.indexBegin(this.wrap(index), height);
                }

                @Override
                public boolean indexComplete(Index index, boolean passed, String message) {
                    return observer.indexComplete(this.wrap(index), passed, message);
                }

                @Override
                public boolean indexNodePassed(long id, int level, int entryCount, int freeBytes, int largeValueCount) {
                    return observer.indexNodePassed(id, level, entryCount, freeBytes, largeValueCount);
                }

                @Override
                public boolean indexNodeFailed(long id, int level, String message) {
                    return observer.indexNodeFailed(id, level, message);
                }

                private Index wrap(Index index) {
                    if (index == UnmodifiableView.this.mSource) {
                        return UnmodifiableView.this;
                    }
                    if (!index.isUnmodifiable()) {
                        index = new UnmodifiableView(index);
                    }
                    return index;
                }
            };
        }
        return ix.verify(obs);
    }

    @Override
    public void close() throws IOException {
        throw new UnmodifiableViewException();
    }

    @Override
    public boolean isClosed() {
        View view = this.mSource;
        if (view instanceof Index) {
            Index ix = (Index)view;
            return ix.isClosed();
        }
        return false;
    }

    @Override
    public void drop() throws IOException {
        throw new UnmodifiableViewException();
    }
}

