/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.views;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.IllegalUpgradeException;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockInterruptedException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnpositionedCursorException;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.core.Utils;

public class ViewUtils {
    public static void positionCheck(Object obj) {
        if (obj == null) {
            throw new UnpositionedCursorException("Cursor position is undefined");
        }
    }

    public static boolean isEmpty(View view) throws IOException {
        Cursor c = view.newCursor(Transaction.BOGUS);
        try {
            c.autoload(false);
            c.first();
            boolean bl = c.key() == null;
            return bl;
        }
        finally {
            c.reset();
        }
    }

    public static long count(View view, boolean autoload, byte[] lowKey, byte[] highKey) throws IOException {
        return ViewUtils.count(view, autoload, lowKey, true, highKey, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(View view, boolean autoload, byte[] lowKey, boolean lowInclusive, byte[] highKey, int highInclusive) throws IOException {
        long count = 0L;
        Cursor c = view.newCursor(Transaction.BOGUS);
        try {
            c.autoload(autoload);
            if (lowKey == null) {
                c.first();
            } else if (lowInclusive) {
                c.findGe(lowKey);
            } else {
                c.findGt(lowKey);
            }
            if (highKey == null) {
                while (c.key() != null) {
                    ++count;
                    c.next();
                }
            } else {
                while (c.key() != null && c.compareKeyTo(highKey) < highInclusive) {
                    ++count;
                    c.next();
                }
            }
        }
        finally {
            c.reset();
        }
        return count;
    }

    public static byte[] appendZero(byte[] key) {
        byte[] newKey = new byte[key.length + 1];
        System.arraycopy(key, 0, newKey, 0, key.length);
        return newKey;
    }

    /*
     * Exception decompiling
     */
    public static LockResult skip(Cursor c, long amount, byte[] limitKey, boolean inclusive) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 11[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static LockResult skipWithLocks(Cursor c, long amount) throws IOException {
        if (amount == 0L) {
            return c.skip(amount);
        }
        if (amount > 0L) {
            while (true) {
                LockResult result = c.next();
                if (c.key() == null || --amount <= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        while (true) {
            LockResult result = c.previous();
            if (c.key() == null || ++amount >= 0L) {
                return result;
            }
            if (result != LockResult.ACQUIRED) continue;
            c.link().unlock();
        }
    }

    static LockResult skipWithLocks(Cursor c, long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == 0L || limitKey == null) {
            return c.skip(amount);
        }
        if (amount > 0L) {
            if (inclusive) {
                while (true) {
                    LockResult result = c.nextLe(limitKey);
                    if (c.key() == null || --amount <= 0L) {
                        return result;
                    }
                    if (result != LockResult.ACQUIRED) continue;
                    c.link().unlock();
                }
            }
            while (true) {
                LockResult result = c.nextLt(limitKey);
                if (c.key() == null || --amount <= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        if (inclusive) {
            while (true) {
                LockResult result = c.previousGe(limitKey);
                if (c.key() == null || ++amount >= 0L) {
                    return result;
                }
                if (result != LockResult.ACQUIRED) continue;
                c.link().unlock();
            }
        }
        while (true) {
            LockResult result = c.previousGt(limitKey);
            if (c.key() == null || ++amount >= 0L) {
                return result;
            }
            if (result != LockResult.ACQUIRED) continue;
            c.link().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResult nextCmp(Cursor c, byte[] limitKey, int cmp) throws IOException {
        block5: {
            block6: {
                LockResult result;
                Utils.keyCheck(limitKey);
                do {
                    boolean auto = c.autoload(false);
                    Transaction txn = c.link(Transaction.BOGUS);
                    try {
                        c.next();
                    }
                    finally {
                        c.link(txn);
                        c.autoload(auto);
                    }
                    if (c.key() == null) break block5;
                    if (c.compareKeyTo(limitKey) >= cmp) break block6;
                    LockResult lockResult = result = auto ? c.load() : c.lock();
                } while (c.value() == null);
                return result;
            }
            c.reset();
        }
        return LockResult.UNOWNED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResult previousCmp(Cursor c, byte[] limitKey, int cmp) throws IOException {
        block5: {
            block6: {
                LockResult result;
                Utils.keyCheck(limitKey);
                do {
                    boolean auto = c.autoload(false);
                    Transaction txn = c.link(Transaction.BOGUS);
                    try {
                        c.previous();
                    }
                    finally {
                        c.link(txn);
                        c.autoload(auto);
                    }
                    if (c.key() == null) break block5;
                    if (c.compareKeyTo(limitKey) <= cmp) break block6;
                    LockResult lockResult = result = auto ? c.load() : c.lock();
                } while (c.value() == null);
                return result;
            }
            c.reset();
        }
        return LockResult.UNOWNED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findNoLock(Cursor c, byte[] key) throws IOException {
        boolean auto = c.autoload(false);
        Transaction txn = c.link(Transaction.BOGUS);
        try {
            c.find(key);
        }
        finally {
            c.link(txn);
            c.autoload(auto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findNearbyNoLock(Cursor c, byte[] key) throws IOException {
        boolean auto = c.autoload(false);
        Transaction txn = c.link(Transaction.BOGUS);
        try {
            c.findNearby(key);
        }
        finally {
            c.link(txn);
            c.autoload(auto);
        }
    }

    public static Transaction enterScope(View view, Transaction txn) throws IOException {
        if (txn == null) {
            txn = view.newTransaction(null);
        } else if (!txn.isBogus()) {
            txn.enter();
        }
        return txn;
    }

    public static Transaction enterScopex(View view, Transaction txn) throws IOException {
        if (txn == null) {
            txn = view.newTransaction(null);
        } else {
            txn.enter();
        }
        return txn;
    }

    public static void commit(Cursor c, byte[] value) throws IOException {
        try {
            c.store(value);
        }
        catch (Throwable e) {
            Transaction txn = c.link();
            if (txn != null) {
                txn.reset(e);
            }
            throw e;
        }
        Transaction txn = c.link();
        if (txn != null && !txn.isBogus()) {
            txn.commit();
        }
    }

    public static byte[] copyValue(byte[] value) {
        return value == Cursor.NOT_LOADED ? value : Utils.cloneArray(value);
    }

    public static boolean step(Cursor c) throws IOException {
        try {
            c.next();
            return c.key() != null;
        }
        catch (UnpositionedCursorException e) {
            return false;
        }
        catch (Throwable e) {
            throw Utils.fail(c, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockResult tryLock(Transaction txn, byte[] key, long nanosTimeout, LockAction action) throws DeadlockException, ViewConstraintException {
        long originalTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        try {
            txn.lockTimeout(nanosTimeout, TimeUnit.NANOSECONDS);
            LockResult lockResult = action.lock(txn, key);
            return lockResult;
        }
        catch (DeadlockException e) {
            if (nanosTimeout == 0L) {
                LockResult lockResult = LockResult.TIMED_OUT_LOCK;
                return lockResult;
            }
            throw e;
        }
        catch (IllegalUpgradeException e) {
            LockResult lockResult = LockResult.ILLEGAL;
            return lockResult;
        }
        catch (LockInterruptedException e) {
            LockResult lockResult = LockResult.INTERRUPTED;
            return lockResult;
        }
        catch (LockFailureException e) {
            LockResult lockResult = LockResult.TIMED_OUT_LOCK;
            return lockResult;
        }
        finally {
            txn.lockTimeout(originalTimeout, TimeUnit.NANOSECONDS);
        }
    }

    static RuntimeException lockCleanup(Throwable e, Transaction txn, LockResult result) {
        if (result.isAcquired()) {
            try {
                txn.unlock();
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
            }
        }
        throw Utils.rethrow(e);
    }

    public static LockResult commonOwned(LockResult a, LockResult b) {
        if (a == LockResult.UNOWNED) {
            return a;
        }
        if (a == LockResult.OWNED_SHARED) {
            return b == LockResult.UNOWNED ? b : a;
        }
        if (a == LockResult.OWNED_UPGRADABLE) {
            return b == LockResult.UNOWNED || b == LockResult.OWNED_SHARED ? b : a;
        }
        if (a == LockResult.OWNED_EXCLUSIVE) {
            return b;
        }
        throw new IllegalArgumentException();
    }

    public static String toString(Index ix) {
        StringBuilder b = new StringBuilder();
        Utils.appendMiniString(b, ix);
        b.append('{');
        String nameStr = ix.nameString();
        if (nameStr != null) {
            b.append("name").append(": ").append(nameStr);
            b.append(", ");
        }
        b.append("id").append(": ").append(ix.id());
        return b.append('}').toString();
    }

    @FunctionalInterface
    public static interface LockAction {
        public LockResult lock(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;
    }
}

