/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.VariableEffect;

public class ConnectivityMatrix {
    private final int[][] coreRegulators;
    private final int[][] extraRegulators;
    private final int[][] coreTargets;
    private final int[][] extraTargets;
    private final VariableEffect[][][] coreRegulatorEffects;
    private final VariableEffect[][][] extraRegulatorEffects;
    private final MDDManager ddmanager;
    private final MDDVariable[] variables;
    private int[] coreFunctions;
    private int[] extraFunctions;

    public ConnectivityMatrix(LogicalModel model) {
        this.ddmanager = model.getMDDManager();
        this.variables = this.ddmanager.getAllVariables();
        this.coreFunctions = model.getLogicalFunctions();
        this.extraFunctions = model.getExtraLogicalFunctions();
        this.coreRegulators = this.fillRegulators(this.ddmanager, this.coreFunctions);
        this.extraRegulators = this.fillRegulators(this.ddmanager, this.extraFunctions);
        this.coreTargets = this.fillTargets(this.coreRegulators.length, this.coreRegulators);
        this.extraTargets = this.fillTargets(this.coreRegulators.length, this.extraRegulators);
        this.coreRegulatorEffects = new VariableEffect[this.coreRegulators.length][][];
        this.extraRegulatorEffects = new VariableEffect[this.extraRegulators.length][][];
    }

    private int[][] fillRegulators(MDDManager ddmanager, int[] functions) {
        int[][] regulators = new int[functions.length][];
        for (int f = 0; f < functions.length; ++f) {
            int function = functions[f];
            boolean[] varFlags = ddmanager.collectDecisionVariables(function);
            int nbRegulators = 0;
            for (boolean b : varFlags) {
                if (!b) continue;
                ++nbRegulators;
            }
            int[] curRegulators = new int[nbRegulators];
            regulators[f] = curRegulators;
            nbRegulators = 0;
            for (int i = 0; i < varFlags.length; ++i) {
                if (!varFlags[i]) continue;
                curRegulators[nbRegulators] = i;
                ++nbRegulators;
            }
        }
        return regulators;
    }

    private int[][] fillTargets(int coreSize, int[][] regulators) {
        int n;
        int[] targetCounts = new int[coreSize];
        int[][] nArray = regulators;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] curRegs;
            int[] nArray2 = curRegs = nArray[i];
            n = nArray2.length;
            for (int j = 0; j < n; ++j) {
                int c;
                int n3 = c = nArray2[j];
                targetCounts[n3] = targetCounts[n3] + 1;
            }
        }
        int[][] targets = new int[coreSize][];
        for (int c = 0; c < targetCounts.length; ++c) {
            targets[c] = new int[targetCounts[c]];
            targetCounts[c] = 0;
        }
        for (int t = 0; t < regulators.length; ++t) {
            int[] curRegs;
            int[] nArray3 = curRegs = regulators[t];
            int n4 = nArray3.length;
            for (n = 0; n < n4; ++n) {
                int c;
                int n5 = c = nArray3[n];
                targetCounts[n5] = targetCounts[n5] + 1;
                targets[c][idx] = t;
            }
        }
        return targets;
    }

    public int[] getRegulators(int idx, boolean extra) {
        if (extra) {
            return this.extraRegulators[idx];
        }
        return this.coreRegulators[idx];
    }

    public int[] getCoreTargets(int idx, boolean extra) {
        if (extra) {
            return this.extraTargets[idx];
        }
        return this.coreTargets[idx];
    }

    public VariableEffect[][] getRegulatorEffects(int idx, boolean extra) {
        VariableEffect[][] ret = null;
        ret = extra ? this.extraRegulatorEffects[idx] : this.coreRegulatorEffects[idx];
        if (ret == null) {
            int function;
            int[] regulators = this.getRegulators(idx, extra);
            ret = new VariableEffect[regulators.length][];
            if (extra) {
                this.extraRegulatorEffects[idx] = ret;
                function = this.extraFunctions[idx];
            } else {
                function = this.coreFunctions[idx];
                this.coreRegulatorEffects[idx] = ret;
            }
            for (int i = 0; i < regulators.length; ++i) {
                MDDVariable var = this.variables[regulators[i]];
                ret[i] = this.ddmanager.getMultivaluedVariableEffect(var, function);
            }
        }
        return ret;
    }
}

