/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.LogicalModelFormat;
import org.colomoto.biolqm.modifier.ModelModifierService;
import org.colomoto.biolqm.modifier.perturbation.PerturbationService;
import org.colomoto.biolqm.service.ExtensionLoader;
import org.colomoto.biolqm.service.LQMServiceManager;
import org.colomoto.biolqm.tool.ModelToolService;

public class LQMLauncher {
    public static void main(String[] args) {
        ExtensionLoader.loadExtensions("extensions", LQMLauncher.class);
        if (args.length < 2) {
            LQMLauncher.error("not enough arguments");
            return;
        }
        if ("-s".equals(args[0])) {
            LQMLauncher.runScript(args, true);
            return;
        }
        if ("-ncs".equals(args[0])) {
            LQMLauncher.runScript(args, false);
            return;
        }
        int argIdx = 0;
        String inputFormat = null;
        if ("-if".equals(args[argIdx])) {
            if (args.length < argIdx + 4) {
                LQMLauncher.error("Not enough arguments after input format");
                return;
            }
            int n = ++argIdx;
            inputFormat = args[n];
        }
        int n = ++argIdx;
        ++argIdx;
        String inputFilename = args[n];
        LogicalModel model = LQMServiceManager.load(inputFilename, inputFormat);
        while (true) {
            if ("-m".equals(args[argIdx])) {
                if (args.length < argIdx + 3) {
                    LQMLauncher.error("Not enough arguments after modifier");
                    return;
                }
                int n2 = ++argIdx;
                ++argIdx;
                String s_modifier = args[n2];
                String s_parameters = "";
                int idx = s_modifier.indexOf(":");
                if (idx >= 0) {
                    s_parameters = s_modifier.substring(idx + 1);
                    s_modifier = s_modifier.substring(0, idx);
                } else {
                    StringBuffer sb = new StringBuffer();
                    while (argIdx < args.length - 1 && !args[argIdx].startsWith("-")) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(args[argIdx]);
                        ++argIdx;
                    }
                    s_parameters = sb.toString();
                }
                ModelModifierService modifier = LQMServiceManager.getModifier(s_modifier);
                try {
                    model = modifier.modify(model, s_parameters);
                }
                catch (Exception e) {
                    System.err.println("Error in model modification step");
                    e.printStackTrace();
                    return;
                }
            }
            if (!"-p".equals(args[argIdx])) break;
            if (args.length < argIdx + 3) {
                LQMLauncher.error("Not enough arguments after modifier");
                return;
            }
            int n3 = ++argIdx;
            ++argIdx;
            String s_parameters = args[n3];
            ModelModifierService modifier = LQMServiceManager.get(PerturbationService.class);
            try {
                model = modifier.modify(model, s_parameters);
            }
            catch (Exception e) {
                System.err.println("Error in model perturbation step");
                e.printStackTrace();
                return;
            }
        }
        if ("-r".equals(args[argIdx])) {
            if (args.length < argIdx + 2) {
                LQMLauncher.error("Not enough arguments after runnable tool");
                return;
            }
            int n4 = ++argIdx;
            ++argIdx;
            String toolID = args[n4];
            ModelToolService tool = LQMServiceManager.getTool(toolID);
            if (tool == null) {
                throw new RuntimeException("Unknown tool: " + toolID);
            }
            String[] parameters = new String[args.length - argIdx];
            System.arraycopy(args, argIdx, parameters, 0, parameters.length);
            tool.getTask(model, parameters).cli();
            return;
        }
        String outputFormat = null;
        if ("-of".equals(args[argIdx])) {
            if (args.length < argIdx + 3) {
                LQMLauncher.error("Not enough arguments after output format");
                return;
            }
            int n5 = ++argIdx;
            outputFormat = args[n5];
        }
        int n6 = ++argIdx;
        String outputTarget = args[n6];
        LQMServiceManager.save(model, outputTarget, outputFormat);
        if (++argIdx < args.length) {
            LQMLauncher.error(args.length - argIdx + " remaining arguments " + args.length + "  " + argIdx);
        }
    }

    private static void runScript(String[] args, boolean compatible_mode) {
        String scriptname = args[1];
        ScriptEngine engine = null;
        try {
            engine = LQMLauncher.loadEngine(scriptname);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        String[] scriptargs = Arrays.copyOfRange(args, 2, args.length);
        try {
            LQMServiceManager lqm = new LQMServiceManager(scriptargs);
            engine.put("lqm", lqm);
            if (compatible_mode) {
                engine.put("lm", lqm);
                engine.put("args", scriptargs);
            }
            engine.eval(new FileReader(scriptname));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LogicalModelFormat getFormat(String name) {
        LogicalModelFormat format = LQMServiceManager.getFormat(name);
        if (format == null) {
            String extension = name.substring(name.lastIndexOf(46) + 1);
            format = LQMServiceManager.getFormat(extension);
        }
        return format;
    }

    public static void error(String message) {
        System.err.println(message);
        LQMLauncher.help();
    }

    public static void help() {
        int n;
        String separator = "------------------------------------------------------------------------------------\n";
        String command = "java -jar bioLQM.jar";
        StringBuffer sb = new StringBuffer();
        sb.append(separator + "| Usage: \n" + separator);
        sb.append("# Convert a single file:\n");
        sb.append(command).append(" [-if informat] infile [-m modifier [options]] [-of outformat] outfile\n");
        sb.append("\n# Run a tool on an imported model:\n");
        sb.append(command).append(" [-if informat] infile [-m modifier [options]] -r tool [options]\n");
        sb.append("\n# Run a script:\n");
        sb.append(command).append(" -s script.js [arguments...]\n");
        sb.append("\n\n" + separator + "| Available formats:\n");
        sb.append("|   '<'/'>': import / export  ; 'b'/'B'/'M' Boolean/Booleanized/Multivalued\n");
        sb.append(separator);
        int namelength = 10;
        for (LogicalModelFormat logicalModelFormat : LQMServiceManager.getFormats()) {
            String string = logicalModelFormat.getID();
            if (string.length() <= namelength) continue;
            namelength = string.length();
        }
        String nameformat = "%1$-" + namelength + "s    ";
        for (LogicalModelFormat logicalModelFormat : LQMServiceManager.getFormats()) {
            String cap = logicalModelFormat.canLoad() ? (logicalModelFormat.canExport() ? " <> " : " <  ") : (logicalModelFormat.canExport() ? "  > " : " -- ");
            String level = logicalModelFormat.getMultivaluedSupport().flag;
            String id = String.format(nameformat, logicalModelFormat.getID());
            sb.append(level).append(cap).append(" ").append(id);
            sb.append("\t").append(logicalModelFormat.getName()).append("\n");
        }
        int n2 = 5;
        namelength = 10;
        for (ModelModifierService modifier : LQMServiceManager.getModifiers()) {
            String id = modifier.getID();
            String name = modifier.getName();
            if (id.length() > n) {
                n = id.length();
            }
            if (name.length() <= namelength) continue;
            namelength = name.length();
        }
        String string = "%1$-" + n + "s    ";
        nameformat = "%1$-" + namelength + "s    ";
        sb.append("\n\n" + separator + "| Available modifiers:\n" + separator);
        for (ModelModifierService modifier : LQMServiceManager.getModifiers()) {
            sb.append(String.format(string, modifier.getID()) + "\t" + String.format(nameformat, modifier.getName()) + modifier.getDescription() + "\n");
        }
        sb.append("\n\n" + separator + "| Available tools:\n" + separator);
        for (ModelToolService tool : LQMServiceManager.getTools()) {
            String level = tool.getMultivaluedSupport().flag;
            sb.append(level).append(" ").append(tool.getID());
            sb.append("\t").append(tool.getName()).append("\n");
        }
        sb.append("\n\n" + separator + "| Examples:\n" + separator);
        sb.append(command).append(" infile.sbml outfile.ginml\n");
        sb.append(command).append(" infile.sbml -m booleanize outfile.sbml\n");
        sb.append(command).append(" -if sbml infile.xml -of ina file.txt\n");
        sb.append(command).append(" -if sbml file1.in...filen.in -of ginml /path/to/outfolder/\n");
        sb.append(command).append(" infile.sbml -r stable\n");
        System.out.println(sb);
    }

    public static ScriptEngine loadEngine(String scriptname) throws Exception {
        File f = new File(scriptname);
        if (!f.exists()) {
            throw new RuntimeException("Unable to find the script file");
        }
        int lastDot = scriptname.lastIndexOf(46);
        if (lastDot < 0) {
            throw new RuntimeException("No extension: unable to guess the scripting language");
        }
        String extension = scriptname.substring(lastDot + 1);
        ScriptEngineManager manager = new ScriptEngineManager(ExtensionLoader.getClassLoader());
        ScriptEngine engine = manager.getEngineByExtension(extension);
        if (engine == null) {
            throw new RuntimeException("No engine found for " + extension);
        }
        return engine;
    }
}

