/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.ModelLayout;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.mddlib.MDDManager;

public class LogicalModelImpl
implements LogicalModel {
    private final MDDManager ddmanager;
    private final List<NodeInfo> coreNodes;
    private final int[] coreFunctions;
    private final List<NodeInfo> extraNodes;
    private final int[] extraFunctions;
    private ModelLayout layout = null;

    public LogicalModelImpl(MDDManager ddmanager, List<NodeInfo> coreNodes, int[] coreFunctions, List<NodeInfo> extraNodes, int[] extraFunctions) {
        this.ddmanager = ddmanager.getManager(coreNodes);
        this.coreNodes = coreNodes;
        this.coreFunctions = coreFunctions;
        if (extraNodes == null) {
            this.extraNodes = new ArrayList<NodeInfo>();
            this.extraFunctions = new int[0];
        } else {
            this.extraNodes = extraNodes;
            this.extraFunctions = extraFunctions;
        }
        for (int f : this.coreFunctions) {
            this.ddmanager.use(f);
        }
        for (int f : this.extraFunctions) {
            this.ddmanager.use(f);
        }
    }

    public LogicalModelImpl(List<NodeInfo> nodeOrder, MDDManager ddmanager, int[] functions) {
        this(ddmanager, nodeOrder, functions, null, null);
    }

    @Override
    public MDDManager getMDDManager() {
        return this.ddmanager;
    }

    @Override
    public List<NodeInfo> getComponents() {
        return this.coreNodes;
    }

    @Override
    public int[] getLogicalFunctions() {
        return this.coreFunctions;
    }

    @Override
    public List<NodeInfo> getExtraComponents() {
        return this.extraNodes;
    }

    @Override
    public boolean hasExtraComponents() {
        return this.extraFunctions != null && this.extraFunctions.length > 0;
    }

    @Override
    public int[] getExtraLogicalFunctions() {
        return this.extraFunctions;
    }

    @Override
    public LogicalModel clone() {
        return this.clone(true);
    }

    @Override
    public LogicalModel clone(boolean keepExtra) {
        LogicalModelImpl newModel = keepExtra ? new LogicalModelImpl(this.ddmanager, this.cloneNodes(this.coreNodes), (int[])this.coreFunctions.clone(), this.cloneNodes(this.extraNodes), (int[])this.extraFunctions.clone()) : new LogicalModelImpl(this.ddmanager, this.cloneNodes(this.coreNodes), (int[])this.coreFunctions.clone(), new ArrayList<NodeInfo>(), new int[0]);
        this.cloneBooleanizedInfo(this.coreNodes);
        if (keepExtra) {
            this.cloneBooleanizedInfo(this.extraNodes);
        }
        if (this.hasLayout()) {
            ModelLayout mlayout = this.getLayout();
            ModelLayout newLayout = newModel.getLayout();
            this.copyLayout(this.getComponents(), newModel.getComponents(), mlayout, newLayout);
            if (keepExtra) {
                this.copyLayout(this.getExtraComponents(), newModel.getExtraComponents(), mlayout, newLayout);
            }
        }
        return newModel;
    }

    private void copyLayout(List<NodeInfo> sourceNodes, List<NodeInfo> targetNodes, ModelLayout sourceLayout, ModelLayout targetLayout) {
        int n = targetNodes.size();
        for (int i = 0; i < n; ++i) {
            targetLayout.copy(targetNodes.get(i), sourceLayout.getInfo(sourceNodes.get(i)));
        }
    }

    private List<NodeInfo> cloneNodes(List<NodeInfo> source) {
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>(source.size());
        for (NodeInfo ni : source) {
            result.add(ni.clone());
        }
        return result;
    }

    private void cloneBooleanizedInfo(List<NodeInfo> source) {
        for (NodeInfo ni : source) {
            NodeInfo[] grp = ni.getBooleanizedGroup();
            if (grp == null) continue;
            NodeInfo[] result = new NodeInfo[grp.length];
            NodeInfo target = this.getComponent(ni.getNodeID());
            for (int i = 0; i < grp.length; ++i) {
                result[i] = this.getComponent(grp[i].getNodeID());
            }
            target.setBooleanizedGroup(result);
        }
    }

    @Override
    public byte getTargetValue(int nodeIdx, byte[] state) {
        return this.ddmanager.reach(this.coreFunctions[nodeIdx], state);
    }

    @Override
    public byte getExtraValue(int nodeIdx, byte[] state) {
        return this.ddmanager.reach(this.extraFunctions[nodeIdx], state);
    }

    @Override
    public void fillExtraValues(byte[] state, byte[] extra) {
        for (int i = 0; i < extra.length; ++i) {
            extra[i] = this.getExtraValue(i, state);
        }
    }

    @Override
    public LogicalModel getView(List<NodeInfo> neworder) {
        MDDManager newmanager = this.ddmanager.getManager(neworder);
        int[] newcorefunctions = new int[this.coreFunctions.length];
        for (int i = 0; i < this.coreFunctions.length; ++i) {
            NodeInfo ni = this.coreNodes.get(i);
            int newidx = neworder.indexOf(ni);
            newcorefunctions[newidx] = this.coreFunctions[i];
        }
        return new LogicalModelImpl(newmanager, neworder, newcorefunctions, this.extraNodes, this.extraFunctions);
    }

    @Override
    public boolean isBoolean() {
        for (NodeInfo ni : this.getComponents()) {
            if (ni.getMax() <= 1) continue;
            return false;
        }
        for (NodeInfo ni : this.getExtraComponents()) {
            if (ni.getMax() <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeInfo getComponent(String id) {
        if (id == null) {
            return null;
        }
        for (NodeInfo ni : this.getComponents()) {
            if (!id.equals(ni.getNodeID())) continue;
            return ni;
        }
        for (NodeInfo ni : this.getExtraComponents()) {
            if (!id.equals(ni.getNodeID())) continue;
            return ni;
        }
        return null;
    }

    @Override
    public int getComponentIndex(String id) {
        if (id == null) {
            return -1;
        }
        int idx = 0;
        for (NodeInfo ni : this.getComponents()) {
            if (id.equals(ni.getNodeID())) {
                return idx;
            }
            ++idx;
        }
        for (NodeInfo ni : this.getExtraComponents()) {
            if (id.equals(ni.getNodeID())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Override
    public Map<String, NodeInfo[]> getBooleanizedMap() {
        HashMap<String, NodeInfo[]> bmap = null;
        for (NodeInfo ni : this.getComponents()) {
            String key;
            NodeInfo[] group = ni.getBooleanizedGroup();
            if (group == null || group[0] != ni) continue;
            if (bmap == null) {
                bmap = new HashMap<String, NodeInfo[]>();
            }
            if ((key = ni.getNodeID()).endsWith("_b1")) {
                key = key.substring(0, key.length() - 3);
            }
            bmap.put(key, group);
        }
        return bmap;
    }

    @Override
    public boolean hasLayout() {
        return this.layout != null;
    }

    @Override
    public ModelLayout getLayout() {
        if (this.layout == null) {
            this.layout = new ModelLayout();
        }
        return this.layout;
    }
}

