/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm;

import java.util.HashMap;
import java.util.Map;
import org.colomoto.biolqm.NodeInfo;

public class ModelLayout {
    private final Map<NodeInfo, LayoutInfo> layout = new HashMap<NodeInfo, LayoutInfo>();

    public LayoutInfo getInfo(NodeInfo ni) {
        return this.layout.get(ni);
    }

    public ModelLayout crop() {
        return this.crop(5);
    }

    public ModelLayout crop(int margin) {
        return this.crop(margin, margin);
    }

    public ModelLayout crop(int marginx, int marginy) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        for (LayoutInfo info : this.layout.values()) {
            if (info.x < minx) {
                minx = info.x;
            }
            if (info.y >= miny) continue;
            miny = info.y;
        }
        minx -= marginx;
        miny -= marginy;
        for (LayoutInfo info : this.layout.values()) {
            info.x -= minx;
            info.y -= miny;
        }
        return this;
    }

    public ModelLayout scale(float scale) {
        return this.scale(scale, scale);
    }

    public ModelLayout scale(float scalex, float scaley) {
        for (LayoutInfo info : this.layout.values()) {
            info.x = (int)((float)info.x * scalex);
            info.y = (int)((float)info.y * scaley);
        }
        return this;
    }

    public LayoutInfo setPosition(NodeInfo ni, int x, int y) {
        LayoutInfo li = this.layout.get(ni);
        if (li == null) {
            li = new LayoutInfo(x, y);
            this.layout.put(ni, li);
            return li;
        }
        li.x = x;
        li.y = y;
        return li;
    }

    public ModelLayout set(NodeInfo ni, int x, int y, int width, int height) {
        LayoutInfo li = this.layout.get(ni);
        if (li == null) {
            li = new LayoutInfo(x, y);
            this.layout.put(ni, li);
            return this;
        }
        li.x = x;
        li.y = y;
        return this;
    }

    public ModelLayout copy(NodeInfo ni, LayoutInfo source) {
        if (source == null) {
            this.layout.remove(ni);
            return this;
        }
        this.set(ni, source.x, source.y, source.width, source.height);
        return this;
    }

    public class LayoutInfo {
        public int x;
        public int y;
        public int width;
        public int height;

        protected LayoutInfo(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        protected LayoutInfo(int x, int y) {
            this(x, y, 0, 0);
        }
    }
}

