/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.implicants;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.helper.implicants.Term;

public class Formula {
    private List<Term> termList;
    private List<Term> originalTermList;
    public final int[] regulators;

    public Formula(List<Term> termList) {
        this(termList, null);
    }

    public Formula(List<Term> termList, int[] regulators) {
        this.termList = termList;
        this.regulators = regulators;
    }

    public int[][] toArray() {
        int[][] resultArray = new int[this.termList.size()][this.termList.get(0).getNumVars()];
        for (int i = 0; i < this.termList.size(); ++i) {
            for (int j = 0; j < this.termList.get(0).getNumVars(); ++j) {
                resultArray[i][j] = this.termList.get(i).getVarsValue(j);
            }
        }
        return resultArray;
    }

    public String toString() {
        String result = "";
        result = result + this.termList.size() + " terms, " + this.termList.get(0).getNumVars() + " variables\n";
        for (int i = 0; i < this.termList.size(); ++i) {
            result = result + this.termList.get(i) + "\n";
        }
        return result;
    }

    public Iterable<Term> getTerms() {
        return this.termList;
    }

    public void reduceToPrimeImplicants() {
        int ones;
        int dontKnows;
        this.originalTermList = new ArrayList<Term>(this.termList);
        if (this.termList.size() == 0) {
            return;
        }
        int numVars = this.termList.get(0).getNumVars();
        ArrayList[][] table = new ArrayList[numVars + 1][numVars + 1];
        for (dontKnows = 0; dontKnows <= numVars; ++dontKnows) {
            for (ones = 0; ones <= numVars; ++ones) {
                table[dontKnows][ones] = new ArrayList();
            }
        }
        for (int i = 0; i < this.termList.size(); ++i) {
            int dontCares = this.termList.get(i).countValues((byte)-1);
            int ones2 = this.termList.get(i).countValues((byte)1);
            table[dontCares][ones2].add(this.termList.get(i));
        }
        for (dontKnows = 0; dontKnows <= numVars - 1; ++dontKnows) {
            for (ones = 0; ones <= numVars - 1; ++ones) {
                ArrayList left = table[dontKnows][ones];
                ArrayList right = table[dontKnows][ones + 1];
                ArrayList out = table[dontKnows + 1][ones];
                for (int leftIdx = 0; leftIdx < left.size(); ++leftIdx) {
                    for (int rightIdx = 0; rightIdx < right.size(); ++rightIdx) {
                        Term combined = ((Term)left.get(leftIdx)).combine((Term)right.get(rightIdx));
                        if (combined == null) continue;
                        if (!out.contains(combined)) {
                            out.add(combined);
                        }
                        this.termList.remove(left.get(leftIdx));
                        this.termList.remove(right.get(rightIdx));
                        if (this.termList.contains(combined)) continue;
                        this.termList.add(combined);
                    }
                }
            }
        }
    }

    public void reducePrimeImplicantsToSubset() {
        int numPrimeImplicants = this.termList.size();
        int numOriginalTerms = this.originalTermList.size();
        boolean[][] table = new boolean[numPrimeImplicants][numOriginalTerms];
        for (int impl = 0; impl < numPrimeImplicants; ++impl) {
            for (int term = 0; term < numOriginalTerms; ++term) {
                table[impl][term] = this.termList.get(impl).implies(this.originalTermList.get(term));
            }
        }
        ArrayList<Term> newTermList = new ArrayList<Term>();
        boolean done = false;
        while (!done) {
            int impl = this.extractEssentialImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            impl = this.extractLargestImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            done = true;
        }
        this.termList = newTermList;
        this.originalTermList = null;
    }

    public static Formula read(Reader reader) throws IOException {
        Term term;
        ArrayList<Term> terms = new ArrayList<Term>();
        while ((term = Term.read(reader)) != null) {
            terms.add(term);
        }
        return new Formula(terms);
    }

    public static Formula readintArray(int[][] states) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (int i = 0; i < states.length; ++i) {
            Term term = Term.readintArray(states[i]);
            terms.add(term);
        }
        return new Formula(terms);
    }

    private int extractEssentialImplicant(boolean[][] table) {
        for (int term = 0; term < table[0].length; ++term) {
            int lastImplFound = -1;
            for (int impl = 0; impl < table.length; ++impl) {
                if (!table[impl][term]) continue;
                if (lastImplFound == -1) {
                    lastImplFound = impl;
                    continue;
                }
                lastImplFound = -1;
                break;
            }
            if (lastImplFound == -1) continue;
            this.extractImplicant(table, lastImplFound);
            return lastImplFound;
        }
        return -1;
    }

    private void extractImplicant(boolean[][] table, int impl) {
        for (int term = 0; term < table[0].length; ++term) {
            if (!table[impl][term]) continue;
            for (int impl2 = 0; impl2 < table.length; ++impl2) {
                table[impl2][term] = false;
            }
        }
    }

    private int extractLargestImplicant(boolean[][] table) {
        int maxNumTerms = 0;
        int maxNumTermsImpl = -1;
        for (int impl = 0; impl < table.length; ++impl) {
            int numTerms = 0;
            for (int term = 0; term < table[0].length; ++term) {
                if (!table[impl][term]) continue;
                ++numTerms;
            }
            if (numTerms <= maxNumTerms) continue;
            maxNumTerms = numTerms;
            maxNumTermsImpl = impl;
        }
        if (maxNumTermsImpl != -1) {
            this.extractImplicant(table, maxNumTermsImpl);
            return maxNumTermsImpl;
        }
        return -1;
    }

    public Formula negatePrimes() {
        int k = this.termList.size();
        if (k < 1) {
            ArrayList<Term> nterms = new ArrayList<Term>();
            nterms.add(new Term(new byte[0]));
            System.out.println("Negate empty formula");
            return new Formula(nterms);
        }
        int[] minindices = new int[k];
        for (int i = 0; i < k; ++i) {
            minindices[i] = 0;
        }
        int n = this.termList.get(0).getNumVars();
        byte[] values = new byte[n];
        for (int i = 0; i < n; ++i) {
            values[i] = -1;
        }
        ArrayList<Term> nterms = new ArrayList<Term>();
        int idx = 0;
        while (idx < k && idx >= 0) {
            int minidx = minindices[idx];
            if (minidx < 0) {
                minindices[idx--] = 0;
                continue;
            }
            Term t = this.termList.get(idx);
            minindices[idx] = minidx = t.findNextRequiredNegation(minidx, values);
            if (minidx >= 0) {
                int n2 = idx;
                minindices[n2] = minindices[n2] + 1;
            }
            if (minidx == -2) {
                minindices[idx--] = 0;
                continue;
            }
            if (++idx != k) continue;
            Term nt = new Term((byte[])values.clone());
            boolean isnew = true;
            for (int pos = 0; pos < nterms.size(); ++pos) {
                Term curt = (Term)nterms.get(pos);
                if (isnew) {
                    if (curt.equals(nt)) {
                        isnew = false;
                        break;
                    }
                    if (curt.implies(nt)) {
                        isnew = false;
                        break;
                    }
                    if (!nt.implies(curt)) continue;
                    nterms.set(pos, nt);
                    isnew = false;
                    continue;
                }
                if (!nt.implies(curt)) continue;
                nterms.remove(pos);
                --pos;
            }
            if (isnew) {
                nterms.add(nt);
            }
            --idx;
        }
        Formula f = new Formula(nterms, this.regulators);
        return f;
    }

    public boolean equals(Formula f) {
        if (this.termList.size() != f.termList.size()) {
            return false;
        }
        return this.termList.containsAll(f.termList);
    }

    public static void main(String[] args) {
        System.out.println("Go primes");
        int[][] states = new int[][]{{1, 1, 0}, {1, 1, 1}, {0, 1, 1}, {1, 0, 1}};
        Formula f = Formula.readintArray(states);
        f.reduceToPrimeImplicants();
        System.out.println(f);
        Formula nf = f.negatePrimes();
        System.out.println(nf);
    }
}

