/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.implicants;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.colomoto.biolqm.helper.implicants.RestrictedPathSearcher;
import org.colomoto.mddlib.MDDManager;

public class ImplicantSearcher
implements Iterable<Integer> {
    private final MDDManager ddmanager;
    private final RestrictedPathSearcher searcher;
    byte[] pattern;
    byte[] term;

    public ImplicantSearcher(MDDManager ddmanager, int value) {
        this.ddmanager = ddmanager;
        this.searcher = new RestrictedPathSearcher(ddmanager, value);
    }

    public byte[] setNode(int node) {
        this.pattern = this.searcher.setNode(node);
        this.term = new byte[this.pattern.length];
        return this.term;
    }

    public boolean[] getRegulators() {
        return this.searcher.getRegulators();
    }

    public int[] getRegulatorList() {
        return this.searcher.getRegulatorList();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ImplicantIterator();
    }

    class ImplicantIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> parentIterator;
        private Integer returnedValue;
        boolean[] jokers;
        private int nextInPattern;

        ImplicantIterator() {
            this.parentIterator = ImplicantSearcher.this.searcher.iterator();
            this.jokers = new boolean[ImplicantSearcher.this.pattern.length];
            this.nextInPattern = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextInPattern > -1) {
                return true;
            }
            return this.parentIterator.hasNext();
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextInPattern < 0) {
                this.returnedValue = this.parentIterator.next();
                for (int i = 0; i < ImplicantSearcher.this.pattern.length; ++i) {
                    if (ImplicantSearcher.this.pattern[i] == -1) {
                        ImplicantSearcher.this.term[i] = 0;
                        this.jokers[i] = true;
                        continue;
                    }
                    ImplicantSearcher.this.term[i] = ImplicantSearcher.this.pattern[i];
                    this.jokers[i] = false;
                }
            } else {
                ImplicantSearcher.this.term[this.nextInPattern] = 1;
                for (int j = 0; j < this.nextInPattern; ++j) {
                    if (!this.jokers[j]) continue;
                    ImplicantSearcher.this.term[j] = 0;
                }
            }
            this.nextInPattern = 0;
            while (this.nextInPattern < ImplicantSearcher.this.pattern.length) {
                if (this.jokers[this.nextInPattern] && ImplicantSearcher.this.term[this.nextInPattern] == 0) {
                    return this.returnedValue;
                }
                ++this.nextInPattern;
            }
            this.nextInPattern = -1;
            return this.returnedValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

