/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.implicants;

import java.util.Iterator;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.PathSearcher;

public class RestrictedPathSearcher
implements Iterable<Integer> {
    private final MDDManager ddmanager;
    private final PathSearcher searcher;
    private final int[] path;
    private boolean[] is_regulator;
    int[] regulators;
    int[] to_regulator;
    byte[] term;

    public RestrictedPathSearcher(MDDManager ddmanager) {
        this.ddmanager = ddmanager;
        this.searcher = new PathSearcher(ddmanager);
        this.path = this.searcher.getPath();
    }

    public RestrictedPathSearcher(MDDManager ddmanager, int value) {
        this.ddmanager = ddmanager;
        this.searcher = new PathSearcher(ddmanager, value);
        this.path = this.searcher.getPath();
    }

    public boolean[] getRegulators() {
        return this.is_regulator;
    }

    public int[] getRegulatorList() {
        return this.to_regulator;
    }

    public byte[] setNode(int node) {
        this.is_regulator = this.ddmanager.collectDecisionVariables(node);
        this.regulators = new int[this.is_regulator.length];
        int nbregulators = 0;
        for (int i = 0; i < this.regulators.length; ++i) {
            this.regulators[i] = this.is_regulator[i] ? nbregulators++ : -1;
        }
        this.to_regulator = new int[nbregulators];
        int cur = 0;
        for (int i = 0; i < this.regulators.length; ++i) {
            if (!this.is_regulator[i]) continue;
            this.to_regulator[cur++] = i;
        }
        this.term = new byte[nbregulators];
        this.searcher.setNode(node);
        return this.term;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RestrictedIterator();
    }

    class RestrictedIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> parentIterator;

        public RestrictedIterator() {
            this.parentIterator = RestrictedPathSearcher.this.searcher.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public Integer next() {
            Integer ret = this.parentIterator.next();
            for (int i = 0; i < RestrictedPathSearcher.this.term.length; ++i) {
                int c = RestrictedPathSearcher.this.path[RestrictedPathSearcher.this.to_regulator[i]];
                RestrictedPathSearcher.this.term[i] = c < 0 ? -1 : (byte)c;
            }
            return ret;
        }
    }
}

