/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.inferinteraction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.colomoto.biolqm.ConnectivityMatrix;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.helper.inferinteraction.PathItem;
import org.colomoto.biolqm.helper.inferinteraction.ReportItem;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class InteractionSearcher {
    protected static final byte FUNC_NON = 1;
    protected static final byte FUNC_POSITIVE = 2;
    protected static final byte FUNC_NEGATIVE = 3;
    protected static final byte FUNC_DUAL = 4;
    private List<PathItem> currentPath;
    private List<ReportItem> currentSource;
    private final LogicalModel model;
    private final ConnectivityMatrix matrix;
    private final MDDManager ddmanager;
    private final MDDVariable[] variables;

    public InteractionSearcher(LogicalModel model) {
        this.model = model;
        this.ddmanager = model.getMDDManager();
        this.variables = this.ddmanager.getAllVariables();
        this.matrix = new ConnectivityMatrix(model);
    }

    public void run() {
        MDDVariable[] variables = this.ddmanager.getAllVariables();
        int[] functions = this.model.getLogicalFunctions();
        for (int n = 0; n < functions.length; ++n) {
            int omdd = functions[n];
            int[] regulators = this.matrix.getRegulators(n, false);
            int nbleaves = 1;
            int[] subtree_sizes = new int[regulators.length];
            for (int i = regulators.length - 1; i >= 0; --i) {
                subtree_sizes[i] = nbleaves;
                nbleaves *= variables[regulators[i]].nbval;
            }
            int[] allleaves = new int[nbleaves];
            this.unfoldMDD(omdd, regulators, subtree_sizes, allleaves);
            for (int r : regulators) {
                System.out.print(r + " ");
            }
            System.out.print(" --> ");
            for (int l : allleaves) {
                if (l < 0) {
                    System.out.print("* ");
                    continue;
                }
                System.out.print(l + " ");
            }
            System.out.println();
            for (int r : regulators) {
                byte srcnbval = variables[r].nbval;
                this.currentSource = new ArrayList<ReportItem>();
                byte functionality = this.computeFunctionality(srcnbval, r, allleaves, subtree_sizes, regulators);
                System.out.println("Found (" + r + "," + n + ") --> " + functionality);
            }
        }
    }

    private void unfoldMDD(int omdd, int[] regulators, int[] subtree_sizes, int[] allLeaves) {
        PathSearcher searcher = new PathSearcher(this.ddmanager);
        searcher.setNode(omdd);
        int[] path = searcher.getPath();
        int[] simplePath = new int[regulators.length];
        Iterator iterator = searcher.iterator();
        while (iterator.hasNext()) {
            int leaf = (Integer)iterator.next();
            if (leaf == 0) continue;
            for (int i = 0; i < regulators.length; ++i) {
                simplePath[i] = path[regulators[i]];
            }
            this.unfoldLeaves(leaf, simplePath, subtree_sizes, allLeaves, regulators, 0, 0);
        }
    }

    private void unfoldLeaves(int leaf, int[] simplePath, int[] subtree_sizes, int[] allLeaves, int[] regulators, int curReg, int idx) {
        while (curReg < simplePath.length) {
            int v = simplePath[curReg];
            int size = subtree_sizes[curReg];
            if (v < 0) {
                int nbval = this.variables[regulators[curReg]].nbval;
                ++curReg;
                for (int k = 0; k < nbval; ++k) {
                    this.unfoldLeaves(leaf, simplePath, subtree_sizes, allLeaves, regulators, curReg, idx);
                    idx += size;
                }
                return;
            }
            idx += v * size;
            ++curReg;
        }
        allLeaves[idx] = leaf;
    }

    private byte computeFunctionality(int count_childs, int node_index, int[] leafs, int[] subtree_size_t, int[] small_node_order) {
        int size_of_subtree = subtree_size_t[node_index];
        ReportItem ri = null;
        int res = 1;
        boolean containsPositive = false;
        boolean containsNegative = false;
        int index = 0;
        while (index + size_of_subtree < leafs.length) {
            for (int i_childs = 0; i_childs < count_childs - 1; ++i_childs) {
                for (int i_subtree = 0; i_subtree < size_of_subtree; ++i_subtree) {
                    int low = leafs[index];
                    int high = leafs[index + size_of_subtree];
                    ri = new ReportItem();
                    ri.targetValue_low = (byte)low;
                    ri.targetValue_high = (byte)high;
                    this.currentPath = new LinkedList<PathItem>();
                    this.log_path(index, node_index, ri, subtree_size_t, small_node_order);
                    if (low < high) {
                        containsPositive = true;
                        res = 2;
                    } else if (low > high) {
                        containsNegative = true;
                        res = 3;
                    } else {
                        res = 1;
                    }
                    ++index;
                    ri.sign = (byte)res;
                    ri.path = this.currentPath;
                    this.currentSource.add(ri);
                }
            }
            index += size_of_subtree;
        }
        if (containsNegative) {
            if (containsPositive) {
                return 4;
            }
            return 3;
        }
        if (containsPositive) {
            return 2;
        }
        return 1;
    }

    private void log_path(int index, int node_index, ReportItem ri, int[] subtree_size_t, int[] small_node_order) {
        for (int k = 0; k < small_node_order.length; ++k) {
            int v = small_node_order[k];
            byte count = (byte)(index / subtree_size_t[k] % this.variables[v].nbval);
            if (k != node_index) {
                PathItem pi = new PathItem();
                pi.targetValue_low = count;
                pi.vertex = v;
                this.currentPath.add(pi);
                continue;
            }
            ri.sourceValue_low = count;
        }
    }
}

