/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.helper.state;

import java.util.ArrayList;
import java.util.HashMap;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.state.StateList;

public class StateListProjection
extends ArrayList<byte[]>
implements StateList {
    StateList parent;
    int[] selectedComponents;
    NodeInfo[] components = null;

    public StateListProjection(StateList parent, Iterable<String> selected) {
        this(parent, StateListProjection.get_selection(parent.getComponents(), selected));
    }

    public StateListProjection(StateList parent, int[] selectedComponents) {
        this.parent = parent;
        this.selectedComponents = selectedComponents;
        this.refresh();
    }

    private void refresh() {
        this.components = new NodeInfo[this.selectedComponents.length];
        NodeInfo[] parentComponents = this.parent.getComponents();
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = parentComponents[this.selectedComponents[i]];
        }
        this.clear();
        int n = this.parent.size();
        byte[] parentState = new byte[this.parent.getComponents().length];
        HashMap<String, Integer> projectionMap = new HashMap<String, Integer>();
        byte[] projectedState = new byte[this.components.length];
        StringBuilder sb = new StringBuilder(this.selectedComponents.length);
        for (int i = 0; i < n; ++i) {
            sb.setLength(0);
            this.parent.fillState(parentState, i);
            int k = 0;
            for (int idx : this.selectedComponents) {
                byte b = parentState[idx];
                sb.append(b);
                projectedState[k++] = b;
            }
            String signature = sb.toString();
            Integer uid = (Integer)projectionMap.get(signature);
            if (uid != null) continue;
            uid = this.size();
            byte[] stored = (byte[])projectedState.clone();
            this.add(stored);
            projectionMap.put(signature, uid);
        }
    }

    @Override
    public NodeInfo[] getComponents() {
        return this.components;
    }

    @Override
    public byte get(int row, int col) {
        return ((byte[])this.get(row))[col];
    }

    @Override
    public boolean setExtra(boolean extra) {
        return this.parent.setExtra(extra);
    }

    @Override
    public byte[] fillState(byte[] state, int index) {
        byte[] innerstate = (byte[])this.get(index);
        if (state == null || state.length != innerstate.length) {
            state = new byte[innerstate.length];
        }
        System.arraycopy(innerstate, 0, state, 0, innerstate.length);
        return state;
    }

    public static int[] get_selection(NodeInfo[] components, Iterable<String> sel) {
        int idx;
        boolean[] selected = new boolean[components.length];
        int n = 0;
        block0: for (String uid : sel) {
            idx = 0;
            for (NodeInfo ni : components) {
                if (ni.getNodeID().equals(uid)) {
                    if (selected[idx]) continue block0;
                    selected[idx] = true;
                    ++n;
                    continue block0;
                }
                ++idx;
            }
        }
        int[] projection = new int[n];
        int k = 0;
        for (idx = 0; idx < selected.length; ++idx) {
            if (!selected[idx]) continue;
            projection[k++] = idx;
        }
        return projection;
    }
}

