/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io;

import java.io.File;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.ModelExporter;
import org.colomoto.biolqm.io.ModelLoader;
import org.colomoto.biolqm.io.StreamProvider;
import org.colomoto.biolqm.service.Service;

public interface LogicalModelFormat
extends Service {
    public boolean canExport();

    public boolean canLoad();

    default public ModelLoader getLoader() {
        throw new UnsupportedOperationException("Saving model is not implemented for format " + this.getID());
    }

    default public ModelExporter getExporter(LogicalModel model) {
        throw new UnsupportedOperationException("Saving model is not implemented for format " + this.getID());
    }

    default public void export(LogicalModel model, StreamProvider streams) throws Exception {
        ModelExporter exporter = this.getExporter(model);
        exporter.setDestination(streams);
        exporter.call();
    }

    default public void export(LogicalModel model, File destination) throws Exception {
        ModelExporter exporter = this.getExporter(model);
        exporter.setDestination(destination);
        exporter.call();
    }

    default public void export(LogicalModel model, String filename) throws Exception {
        ModelExporter exporter = this.getExporter(model);
        exporter.setDestination(filename);
        exporter.call();
    }

    default public LogicalModel load(StreamProvider streams) throws Exception {
        ModelLoader loader = this.getLoader();
        loader.setSource(streams);
        return (LogicalModel)loader.call();
    }

    default public LogicalModel load(File source) throws Exception {
        ModelLoader loader = this.getLoader();
        loader.setSource(source);
        return (LogicalModel)loader.call();
    }

    default public LogicalModel load(String filename) throws Exception {
        ModelLoader loader = this.getLoader();
        loader.setSource(filename);
        return (LogicalModel)loader.call();
    }
}

