/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.colomoto.biolqm.io.StreamProviderFileImpl;

public interface StreamProvider {
    public static StreamProvider create(File f) {
        return new StreamProviderFileImpl(f);
    }

    public static StreamProvider create(String path) {
        return new StreamProviderFileImpl(path);
    }

    default public OutputStream output() throws IOException {
        return this.output("$f");
    }

    public OutputStream output(String var1) throws IOException;

    default public InputStream input() throws IOException {
        return this.input("$f");
    }

    public InputStream input(String var1) throws IOException;

    default public Reader reader() throws IOException {
        return new InputStreamReader(this.input());
    }

    default public Reader reader(String pattern) throws IOException {
        return new InputStreamReader(this.input(pattern));
    }

    default public OutputStreamWriter writer() throws IOException {
        return new OutputStreamWriter(this.output());
    }

    default public OutputStreamWriter writer(String pattern) throws IOException {
        return new OutputStreamWriter(this.output(pattern));
    }

    default public void close() {
    }

    @Deprecated
    default public File getFile() {
        throw new UnsupportedOperationException();
    }
}

