/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.colomoto.biolqm.io.StreamProvider;

public class StreamProviderFileImpl
implements StreamProvider {
    private final File parent;
    private final String filename;

    StreamProviderFileImpl(String filename) {
        this(new File(filename));
    }

    StreamProviderFileImpl(File file) {
        this.parent = file.getParentFile();
        this.filename = file.getName();
    }

    @Override
    public InputStream input(String pattern) throws IOException {
        return new FileInputStream(this.getFile(pattern));
    }

    @Override
    public OutputStream output(String pattern) throws IOException {
        return new FileOutputStream(this.getFile(pattern));
    }

    private File getFile(String pattern) {
        String[] path;
        File f = this.parent;
        for (String s : path = pattern.split("/")) {
            s = s.replace("$f", this.filename);
            f = new File(f, s);
        }
        return f;
    }

    @Override
    public File getFile() {
        return new File(this.parent, this.filename);
    }
}

