/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.antlr;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.antlr.Assignment;
import org.colomoto.biolqm.io.antlr.Operator;
import org.colomoto.biolqm.io.antlr.Value;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDOperator;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.ValueNode;
import org.colomoto.mddlib.logicalfunction.operators.AndOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.NotOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.OrOperatorFactory;
import org.colomoto.mddlib.operators.OverwriteOperator;

public class ExpressionStack {
    private Stack<FunctionNode> stack = new Stack();
    private final OperandFactory operandFactory;

    public static LogicalModel constructModel(OperandFactory operandFactory, List<NodeInfo> nodes, Map<NodeInfo, FunctionNode> var2function) {
        MDDManager manager = operandFactory.getMDDManager();
        int[] functions = new int[nodes.size()];
        for (int i = 0; i < functions.length; ++i) {
            FunctionNode node = var2function.get(nodes.get(i));
            functions[i] = node == null ? 0 : node.getMDD(manager);
        }
        return new LogicalModelImpl(nodes, manager, functions);
    }

    public static LogicalModel constructMVModel(OperandFactory operandFactory, List<NodeInfo> nodes, Map<NodeInfo, List<Assignment>> var2assign) {
        MDDVariableFactory mvf = new MDDVariableFactory();
        for (NodeInfo ni : nodes) {
            mvf.add((Object)ni, (byte)(ni.getMax() + 1));
        }
        MDDManager manager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)10);
        int[] functions = new int[nodes.size()];
        for (int i = 0; i < functions.length; ++i) {
            NodeInfo ni = nodes.get(i);
            List<Assignment> asgs = var2assign.get(ni);
            functions[i] = 0;
            for (Assignment asg : asgs) {
                if (asg == null) continue;
                int overMDD = asg.condition.getMDD(manager);
                MDDOperator op = OverwriteOperator.getOverwriteAction((int)asg.value);
                int old = functions[i];
                functions[i] = op.combine(manager, old, overMDD);
                manager.free(overMDD);
                manager.free(old);
            }
        }
        return new LogicalModelImpl(nodes, manager, functions);
    }

    public ExpressionStack(OperandFactory operandFactory) {
        this.operandFactory = operandFactory;
    }

    public void operator(Operator op) {
        FunctionNode result = null;
        switch (op) {
            case AND: {
                result = AndOperatorFactory.FACTORY.getNode(this.stack);
                break;
            }
            case OR: {
                result = OrOperatorFactory.FACTORY.getNode(this.stack);
            }
        }
        if (result == null) {
            return;
        }
        this.stack.add(result);
    }

    public void not() {
        FunctionNode node = this.stack.pop();
        if (node == ValueNode.TRUE) {
            this.stack.add((FunctionNode)ValueNode.FALSE);
        } else if (node == ValueNode.FALSE) {
            this.stack.add((FunctionNode)ValueNode.TRUE);
        } else {
            this.stack.add(NotOperatorFactory.FACTORY.getNode(node));
        }
    }

    public void value(Value v) {
        switch (v) {
            case TRUE: {
                this.stack.add((FunctionNode)ValueNode.TRUE);
                break;
            }
            case FALSE: {
                this.stack.add((FunctionNode)ValueNode.FALSE);
            }
        }
    }

    public void ident(String name) {
        FunctionNode node = this.operandFactory.createOperand(name);
        if (node == null) {
            throw new RuntimeException("Operand could not be created");
        }
        this.stack.add(node);
    }

    public void ident(String name, int threshold) {
        FunctionNode node = this.operandFactory.createOperand(name, threshold);
        if (node == null) {
            throw new RuntimeException("Operand could not be created");
        }
        this.stack.add(node);
    }

    public FunctionNode done() {
        if (this.stack.size() != 1) {
            throw new RuntimeException("The stack is messed-up");
        }
        return this.stack.pop();
    }

    public void clear() {
        this.stack.clear();
    }
}

