/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.bnet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class BNetExport
extends BaseExporter {
    public BNetExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager);
        OutputStreamWriter writer = this.streams.writer();
        writer.write("# model in BoolNet format\n");
        writer.write("# the header targets, factors is mandatory to be importable in the R package BoolNet\n");
        writer.write("\n");
        writer.write("targets, factors\n");
        int[] functions = this.model.getLogicalFunctions();
        String[] names = new String[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            names[i] = variables[i].key.toString();
        }
        int width = 5;
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= width) continue;
            width = names[i].length();
        }
        Object[] names_sorted = Arrays.copyOf(names, names.length);
        Arrays.sort(names_sorted);
        for (int i = 0; i < names_sorted.length; ++i) {
            int idx = Arrays.asList(names).indexOf(names_sorted[i]);
            MDDVariable var = variables[idx];
            int length = width - names[idx].length();
            String gap = new String(new char[length]).replace("\u0000", " ");
            writer.write(var + ", " + gap);
            int function = functions[idx];
            if (ddmanager.isleaf(function)) {
                writer.write(function + "\n");
                continue;
            }
            int[] path = searcher.setNode(function);
            boolean first = true;
            boolean multiple = false;
            StringBuffer funcBuffer = new StringBuffer();
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                if (!first) {
                    funcBuffer.append(" | ");
                    multiple = true;
                } else {
                    first = false;
                }
                boolean andFirst = true;
                for (int j = 0; j < path.length; ++j) {
                    int cst = path[j];
                    if (cst < 0) continue;
                    if (!andFirst) {
                        funcBuffer.append("&");
                    }
                    if (cst == 0) {
                        funcBuffer.append("!" + variables[j].key);
                    } else {
                        funcBuffer.append(variables[j].key.toString());
                    }
                    andFirst = false;
                }
            }
            if (multiple) {
                writer.write(funcBuffer.toString());
            } else {
                writer.write(funcBuffer.toString());
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }
}

