/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.boolsim;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class BoolSimExport
extends BaseExporter {
    public BoolSimExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager);
        OutputStreamWriter writer = this.streams.writer();
        int[] functions = this.model.getLogicalFunctions();
        for (int idx = 0; idx < functions.length; ++idx) {
            MDDVariable var = variables[idx];
            int[] path = searcher.setNode(functions[idx]);
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                boolean first = true;
                boolean fixed = true;
                for (int i = 0; i < path.length; ++i) {
                    int cst = path[i];
                    if (cst < 0) continue;
                    fixed = false;
                    if (!first) {
                        writer.write("&");
                    }
                    if (cst == 0) {
                        writer.write("^" + variables[i].key);
                    } else {
                        writer.write(variables[i].key.toString());
                    }
                    first = false;
                }
                if (fixed) {
                    writer.write(var + " -> " + var + "\n");
                    writer.write("^" + var + " -> " + var + "\n");
                    continue;
                }
                writer.write(" -> " + var + "\n");
            }
        }
        ((Writer)writer).close();
    }
}

