/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.boolsim;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.antlr.BoolsimLexer;
import org.colomoto.biolqm.io.antlr.BoolsimParser;
import org.colomoto.biolqm.io.antlr.ErrorListener;
import org.colomoto.biolqm.io.antlr.ExpressionStack;
import org.colomoto.biolqm.io.boolsim.BoolsimParserListener;
import org.colomoto.biolqm.io.boolsim.BoolsimVariableCollector;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.SimpleOperandFactory;
import org.colomoto.mddlib.logicalfunction.operators.AndOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.NotOperatorFactory;
import org.colomoto.mddlib.logicalfunction.operators.OrOperatorFactory;

public class BoolSimImport
extends BaseLoader {
    @Override
    public LogicalModel performTask() throws IOException {
        ANTLRInputStream input = new ANTLRInputStream(this.streams.reader());
        ErrorListener errors = new ErrorListener();
        BoolsimParser parser = BoolSimImport.getParser((CharStream)input, errors);
        BoolsimParser.ModelContext mctx = parser.model();
        if (errors.hasErrors()) {
            System.out.println("Found some errors:");
            for (String s : errors.getErrors()) {
                System.out.println("  " + s);
            }
            return null;
        }
        BoolsimVariableCollector collector = new BoolsimVariableCollector();
        for (BoolsimParser.AssignContext actx : mctx.assign()) {
            collector.exitVar(actx.var());
        }
        List<NodeInfo> variables = collector.findVariables((ParseTree)mctx);
        SimpleOperandFactory operandFactory = new SimpleOperandFactory(variables);
        BoolsimParserListener listener = new BoolsimParserListener((OperandFactory)operandFactory);
        HashMap<NodeInfo, FunctionNode[]> var2functions = new HashMap<NodeInfo, FunctionNode[]>();
        Map<String, NodeInfo> id2var = collector.getVarMap();
        for (BoolsimParser.AssignContext actx : mctx.assign()) {
            FunctionNode curNode;
            String id = actx.var().ID().getText();
            int signIdx = 0;
            if (actx.op().POSITIVE() == null) {
                signIdx = 1;
            }
            NodeInfo ni = id2var.get(id);
            FunctionNode node = listener.loadExpr((ParseTree)actx.expr());
            FunctionNode[] functions = (FunctionNode[])var2functions.get(ni);
            if (functions == null) {
                functions = new FunctionNode[2];
                var2functions.put(ni, functions);
            }
            if ((curNode = functions[signIdx]) != null) {
                node = OrOperatorFactory.FACTORY.getNode(curNode, node);
            }
            functions[signIdx] = node;
        }
        HashMap<NodeInfo, FunctionNode> var2function = new HashMap<NodeInfo, FunctionNode>();
        for (NodeInfo ni : var2functions.keySet()) {
            FunctionNode[] functions = (FunctionNode[])var2functions.get(ni);
            FunctionNode posNode = functions[0];
            FunctionNode negNode = functions[1];
            if (negNode != null) {
                negNode = NotOperatorFactory.FACTORY.getNode(negNode);
                if (posNode != null) {
                    negNode = AndOperatorFactory.FACTORY.getNode(posNode, negNode);
                }
                var2function.put(ni, negNode);
                continue;
            }
            var2function.put(ni, posNode);
        }
        return ExpressionStack.constructModel((OperandFactory)operandFactory, variables, var2function);
    }

    private static BoolsimParser getParser(CharStream input, ErrorListener errors) {
        BoolsimLexer lexer = new BoolsimLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BoolsimParser parser = new BoolsimParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errors);
        return parser;
    }
}

