/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.cnet;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.antlr.CNetLexer;
import org.colomoto.biolqm.io.antlr.CNetParser;
import org.colomoto.biolqm.io.antlr.ErrorListener;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDVariableFactory;

public class CNetImport
extends BaseLoader {
    public static Pattern PATTERN_commentID = Pattern.compile("#+\\s*([a-zA-Z_][a-zA-Z0-9_]*)");

    @Override
    protected LogicalModel performTask() throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(this.streams.reader());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)new CNetLexer((CharStream)input));
        CNetParser parser = new CNetParser((TokenStream)tokens);
        ErrorListener errors = new ErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errors);
        CNetParser.ModelContext mtx = parser.model();
        int nbvar = Integer.parseInt(mtx.count().getText());
        ArrayList<NodeInfo> components = new ArrayList<NodeInfo>(nbvar);
        for (int idx = 0; idx < nbvar; ++idx) {
            components.add(new NodeInfo("G" + idx));
        }
        MDDVariableFactory mvf = new MDDVariableFactory();
        byte max = 5;
        for (NodeInfo ni : components) {
            byte curmax = ni.getMax();
            if (curmax > max) {
                max = curmax;
            }
            mvf.add((Object)ni, (byte)(curmax + 1));
        }
        MDDManager ddmanager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)(max + 1));
        int[] functions = new int[nbvar];
        for (CNetParser.TableContext ttx : mtx.table()) {
            int f;
            String comment;
            Matcher m;
            int curComponent = this.getNodeIndex(ttx.curvar().getText());
            List hidden = tokens.getHiddenTokensToLeft(ttx.getStart().getTokenIndex(), 2);
            if (hidden != null && (m = PATTERN_commentID.matcher(comment = ((Token)hidden.get(hidden.size() - 1)).getText().trim())).matches()) {
                ((NodeInfo)components.get(curComponent)).setNodeID(m.group(1));
            }
            int count = Integer.parseInt(ttx.count().getText());
            int[] regulators = new int[count];
            int i = 0;
            for (CNetParser.VaridContext vtx : ttx.varid()) {
                regulators[i++] = this.getNodeIndex(vtx.getText());
            }
            List<CNetParser.LineContext> ttlines = ttx.line();
            ArrayList<byte[]> states = new ArrayList<byte[]>(ttlines.size());
            for (CNetParser.LineContext ltx : ttlines) {
                int k;
                String line = ltx.ttline().getText().trim();
                if (line.length() != count + 1) {
                    throw new RuntimeException("Wrong number of values in truth table line: " + line.length() + " expected " + (count + 1));
                }
                int targetValue = Character.getNumericValue(line.charAt(count));
                if (targetValue < 0 || targetValue > 1) {
                    throw new RuntimeException("Invalid target value");
                }
                if (targetValue == 0) continue;
                byte[] vals = new byte[count];
                for (int idx = 0; idx < count; ++idx) {
                    vals[idx] = (byte)Character.getNumericValue(line.charAt(idx));
                }
                byte[] state = new byte[nbvar];
                for (k = 0; k < state.length; ++k) {
                    state[k] = -1;
                }
                for (k = 0; k < regulators.length; ++k) {
                    state[regulators[k]] = vals[k];
                }
                states.add(state);
            }
            functions[curComponent] = f = ddmanager.nodeFromStates(states, 1);
        }
        return new LogicalModelImpl(components, ddmanager, functions);
    }

    private int getNodeIndex(String s) {
        return Integer.parseInt(s) - 1;
    }
}

