/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.implicanttables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.antlr.ErrorListener;
import org.colomoto.biolqm.io.antlr.ITNETLexer;
import org.colomoto.biolqm.io.antlr.ITNETParser;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class ImplicantTableImport
extends BaseLoader {
    @Override
    protected LogicalModel performTask() throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(this.streams.reader());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)new ITNETLexer((CharStream)input));
        ITNETParser parser = new ITNETParser((TokenStream)tokens);
        ErrorListener errors = new ErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errors);
        ITNETParser.ModelContext mtx = parser.model();
        List<ITNETParser.TableContext> tables = mtx.table();
        int nbvar = tables.size();
        ArrayList<NodeInfo> components = new ArrayList<NodeInfo>(nbvar);
        HashMap<String, Integer> id2index = new HashMap<String, Integer>();
        MDDVariableFactory mvf = new MDDVariableFactory();
        byte max = 5;
        for (int idx = 0; idx < nbvar; ++idx) {
            ITNETParser.TableContext ttx = tables.get(idx);
            String id = ttx.curvar().getText();
            id2index.put(id, idx);
            byte curmax = 1;
            try {
                curmax = Byte.parseByte(ttx.max().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            NodeInfo ni = new NodeInfo(id, curmax);
            components.add(ni);
            if (curmax > max) {
                max = curmax;
            }
            mvf.add((Object)ni, (byte)(curmax + 1));
        }
        MDDManager ddmanager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)(max + 1));
        int[] functions = new int[nbvar];
        for (ITNETParser.TableContext ttx : mtx.table()) {
            int curComponent = (Integer)id2index.get(ttx.curvar().getText());
            List<ITNETParser.VarContext> regulatorIDs = ttx.var();
            int[] regulators = new int[regulatorIDs.size()];
            int i = 0;
            for (ITNETParser.VarContext vtx : regulatorIDs) {
                regulators[i++] = (Integer)id2index.get(vtx.getText());
            }
            List<ITNETParser.LineContext> ttlines = ttx.line();
            int count = regulators.length;
            int f = 0;
            for (ITNETParser.LineContext ltx : ttlines) {
                int k;
                int targetValue = Integer.parseInt(ltx.target().getText());
                if (targetValue == 0) continue;
                String line = ltx.ttline().getText().trim();
                if (line.length() != count) {
                    throw new RuntimeException("Wrong number of values in implicant table line: " + line.length() + " expected " + count);
                }
                byte[] vals = new byte[count];
                for (int idx = 0; idx < count; ++idx) {
                    vals[idx] = (byte)Character.getNumericValue(line.charAt(idx));
                }
                byte[] state = new byte[nbvar];
                for (k = 0; k < state.length; ++k) {
                    state[k] = -1;
                }
                for (k = 0; k < regulators.length; ++k) {
                    state[regulators[k]] = vals[k];
                }
                int newNode = ddmanager.nodeFromState(state, targetValue);
                int nextNode = MDDBaseOperators.OR.combine(ddmanager, f, newNode);
                ddmanager.free(newNode);
                ddmanager.free(f);
                f = nextNode;
            }
            functions[curComponent] = f;
        }
        return new LogicalModelImpl(components, ddmanager, functions);
    }
}

