/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.mnet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class MNetExport
extends BaseExporter {
    public MNetExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        MDDManager ddmanager = this.model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager, true);
        OutputStreamWriter writer = this.streams.writer();
        int width = 1;
        int[] functions = this.model.getLogicalFunctions();
        String[] names = new String[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            names[i] = variables[i].key.toString();
            int w = names[i].length();
            if (variables[i].nbval > 2) {
                w += 2;
            }
            if (w <= width) continue;
            width = w;
        }
        for (int idx = 0; idx < names.length; ++idx) {
            int function = functions[idx];
            MDDVariable var = variables[idx];
            int length = width - names[idx].length();
            if (var.nbval > 2) {
                length -= 2;
            }
            String gap = new String(new char[length]).replace("\u0000", " ");
            if (ddmanager.isleaf(function)) {
                if (var.nbval == 2) {
                    writer.write(var + gap + " <- " + function + "\n");
                    continue;
                }
                writer.write(var + ":" + function + gap + " <- 1\n");
                continue;
            }
            int[] path = searcher.setNode(function);
            int[] max = searcher.getMax();
            StringBuffer[] funcBuffers = new StringBuffer[var.nbval - 1];
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                StringBuffer sb = funcBuffers[leaf - 1];
                if (sb == null) {
                    funcBuffers[leaf - 1] = sb = new StringBuffer();
                } else {
                    sb.append(" | ");
                }
                boolean andFirst = true;
                for (int j = 0; j < path.length; ++j) {
                    int cst_min = path[j];
                    int cst_max = max[j];
                    if (cst_min < 0) continue;
                    MDDVariable reg = variables[j];
                    String regname = reg.key.toString();
                    cst_max = cst_max + 1 < reg.nbval ? ++cst_max : -1;
                    if (!andFirst) {
                        sb.append(" & ");
                    }
                    andFirst = false;
                    if (cst_min == 0 && cst_max == 0) {
                        sb.append("!" + regname);
                        continue;
                    }
                    if (cst_min > 0) {
                        sb.append(regname);
                        if (reg.nbval > 2) {
                            sb.append(":" + cst_min);
                        }
                    }
                    if (cst_max < cst_min) continue;
                    if (cst_min > 0) {
                        sb.append(" & ");
                    }
                    sb.append("!" + regname);
                    if (reg.nbval <= 2) continue;
                    sb.append(":" + cst_max);
                }
            }
            if (var.nbval > 2) {
                for (int i = 0; i < funcBuffers.length; ++i) {
                    StringBuffer sb = funcBuffers[i];
                    if (sb == null) continue;
                    int v = i + 1;
                    writer.write(var + ":" + v + gap + " <- " + funcBuffers[i].toString() + "\n");
                }
                continue;
            }
            writer.write(var + gap + " <- " + funcBuffers[0].toString() + "\n");
        }
        ((Writer)writer).close();
    }
}

