/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.mnet;

import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.colomoto.biolqm.io.antlr.ExpressionStack;
import org.colomoto.biolqm.io.antlr.MNetBaseListener;
import org.colomoto.biolqm.io.antlr.MNetParser;
import org.colomoto.biolqm.io.antlr.Operator;
import org.colomoto.biolqm.io.antlr.Value;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;

class MNetParserListener
extends MNetBaseListener {
    private final ParseTreeWalker walker = new ParseTreeWalker();
    private final ExpressionStack stack;

    public MNetParserListener(OperandFactory operandFactory) {
        this.stack = new ExpressionStack(operandFactory);
    }

    public FunctionNode loadExpr(ParseTree expr) {
        this.stack.clear();
        this.walker.walk((ParseTreeListener)this, expr);
        return this.stack.done();
    }

    @Override
    public void exitVar(@NotNull MNetParser.VarContext ctx) {
        String var = ctx.ID().getText();
        if (ctx.VALUE() != null) {
            int v = Integer.parseInt(ctx.VALUE().getText());
            this.stack.ident(var, v);
        } else {
            this.stack.ident(var);
        }
    }

    @Override
    public void exitVal(@NotNull MNetParser.ValContext ctx) {
        String s = ctx.VALUE().getText().trim();
        if ("true".equalsIgnoreCase(s)) {
            this.stack.value(Value.TRUE);
            return;
        }
        if ("false".equalsIgnoreCase(s)) {
            this.stack.value(Value.TRUE);
            return;
        }
        try {
            int v = Integer.parseInt(s);
            if (v > 0) {
                this.stack.value(Value.TRUE);
            } else {
                this.stack.value(Value.FALSE);
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid value");
        }
    }

    @Override
    public void exitAndExpr(@NotNull MNetParser.AndExprContext ctx) {
        this.stack.operator(Operator.AND);
    }

    @Override
    public void exitOrExpr(@NotNull MNetParser.OrExprContext ctx) {
        this.stack.operator(Operator.OR);
    }

    @Override
    public void exitSimpleExpr(@NotNull MNetParser.SimpleExprContext ctx) {
        List<MNetParser.NotContext> nots = ctx.not();
        if (nots != null && nots.size() % 2 > 0) {
            this.stack.not();
        }
    }
}

