/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.sbml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.colomoto.biolqm.ConnectivityMatrix;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.ModelLayout;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.biolqm.io.sbml.SBMLQualBundle;
import org.colomoto.biolqm.io.sbml.SBMLqualHelper;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLWriter;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.GeneralGlyph;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.InputTransitionEffect;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Sign;
import org.sbml.jsbml.ext.qual.Transition;

public class SBMLqualExport
extends BaseExporter {
    private final ConnectivityMatrix matrix;
    private final MDDManager ddmanager;
    private final SBMLQualBundle qualBundle;
    private final List<NodeInfo> coreNodes;
    private final PathSearcher searcher;
    private Map<NodeInfo, QualitativeSpecies> node2species = new HashMap<NodeInfo, QualitativeSpecies>();
    private String[] coreIDS;
    private boolean needFilled = true;
    private String tr_prefix = "tr_";

    public SBMLqualExport(LogicalModel model) {
        this(model, model.hasLayout());
    }

    public SBMLqualExport(LogicalModel model, boolean addLayout) {
        super(model);
        this.ddmanager = model.getMDDManager();
        this.searcher = new PathSearcher(this.ddmanager, true);
        this.matrix = new ConnectivityMatrix(model);
        this.coreNodes = model.getComponents();
        this.qualBundle = SBMLqualHelper.newBundle(addLayout);
    }

    @Override
    public void export() throws IOException {
        try {
            SBMLWriter writer = new SBMLWriter();
            writer.write(this.getSBMLDocument(), this.streams.output());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public SBMLDocument getSBMLDocument() {
        return this.getSBMLBundle().document;
    }

    public SBMLQualBundle getSBMLBundle() {
        this.ensureFilled();
        return this.qualBundle;
    }

    private void ensureTransitionPrefix() {
        String curID;
        for (NodeInfo ni : this.coreNodes) {
            curID = ni.getNodeID();
            while (curID.startsWith(this.tr_prefix)) {
                this.tr_prefix = this.tr_prefix + "_";
            }
        }
        for (NodeInfo ni : this.model.getExtraComponents()) {
            curID = ni.getNodeID();
            while (curID.startsWith(this.tr_prefix)) {
                this.tr_prefix = this.tr_prefix + "_";
            }
        }
    }

    public synchronized void ensureFilled() {
        if (this.needFilled) {
            NodeInfo ni;
            int i;
            this.ensureTransitionPrefix();
            this.needFilled = false;
            Compartment comp1 = this.qualBundle.model.createCompartment("comp1");
            comp1.setConstant(true);
            List<NodeInfo> nodes = this.coreNodes;
            this.coreIDS = new String[this.coreNodes.size()];
            int[] functions = this.model.getLogicalFunctions();
            for (i = 0; i < functions.length; ++i) {
                String curID;
                ni = nodes.get(i);
                this.coreIDS[i] = curID = ni.getNodeID();
                QualitativeSpecies sp = this.qualBundle.qmodel.createQualitativeSpecies(curID, comp1);
                sp.setMaxLevel((int)ni.getMax());
                this.node2species.put(ni, sp);
                String name = ni.getName();
                if (name != null && name.length() > 0) {
                    sp.setName(name);
                }
                if (ni.isInput()) {
                    sp.setConstant(true);
                    continue;
                }
                sp.setConstant(false);
            }
            for (i = 0; i < functions.length; ++i) {
                ni = nodes.get(i);
                if (ni.isInput()) continue;
                this.addTransition(nodes.get(i), functions[i], this.matrix.getRegulators(i, false));
            }
            nodes = this.model.getExtraComponents();
            functions = this.model.getExtraLogicalFunctions();
            for (i = 0; i < functions.length; ++i) {
                ni = nodes.get(i);
                int function = functions[i];
                String curID = ni.getNodeID();
                QualitativeSpecies sp = this.qualBundle.qmodel.createQualitativeSpecies(curID, comp1);
                sp.setConstant(false);
                this.node2species.put(ni, sp);
                if (ni.isInput()) {
                    sp.setConstant(true);
                }
                this.addTransition(ni, function, this.matrix.getRegulators(i, true));
                ++i;
            }
            if (this.model.hasLayout()) {
                ModelLayout mlayout = this.model.getLayout();
                Layout layout = new Layout();
                layout.setId("__layout__");
                this.qualBundle.lmodel.addLayout(layout);
                double width = 0.0;
                double height = 0.0;
                for (NodeInfo ni2 : this.model.getComponents()) {
                    ModelLayout.LayoutInfo li = mlayout.getInfo(ni2);
                    int x = li.x;
                    int w = li.width;
                    int y = li.y;
                    int h = li.height;
                    String id = this.getSpecies(ni2).getId();
                    GeneralGlyph glyph = new GeneralGlyph();
                    glyph.setReference(id);
                    glyph.setId("_ly_" + id);
                    BoundingBox bb = new BoundingBox();
                    Point pos = bb.createPosition();
                    pos.setX((double)x);
                    pos.setY((double)y);
                    Dimensions dim = bb.createDimensions();
                    dim.setWidth((double)w);
                    dim.setHeight((double)h);
                    if ((double)(x + w) > width) {
                        width = x + w;
                    }
                    if ((double)(y + h) > height) {
                        height = y + h;
                    }
                    glyph.setBoundingBox(bb);
                    layout.addGeneralGlyph(glyph);
                }
                Dimensions dims = new Dimensions();
                dims.setWidth(width);
                dims.setHeight(height);
                layout.setDimensions(dims);
            }
        }
    }

    public void setInitialCondition(byte[] state) {
        this.ensureFilled();
        for (int idx = 0; idx < state.length; ++idx) {
            NodeInfo ni;
            QualitativeSpecies species;
            byte v = state[idx];
            if (v < 0 || (species = this.getSpecies(ni = this.coreNodes.get(idx))) == null) continue;
            species.setInitialLevel((int)v);
        }
    }

    public QualitativeSpecies getSpecies(NodeInfo ni) {
        return this.node2species.get(ni);
    }

    private void addTransition(NodeInfo ni, int function, int[] regulators) {
        Object ni_reg;
        String trID = this.tr_prefix + ni.getNodeID();
        Transition tr = this.qualBundle.qmodel.createTransition(trID + "_");
        tr.createOutput(trID + "_out", this.node2species.get(ni), OutputTransitionEffect.assignmentLevel);
        if (this.ddmanager.isleaf(function)) {
            FunctionTerm functionTerm = new FunctionTerm();
            functionTerm.setDefaultTerm(true);
            functionTerm.setResultLevel(function);
            tr.addFunctionTerm(functionTerm);
            return;
        }
        for (int idx : regulators) {
            ni_reg = this.coreNodes.get(idx);
            Input in = tr.createInput(trID + "_in_" + idx, this.node2species.get(ni_reg), InputTransitionEffect.none);
            Sign sign = Sign.unknown;
            MDDVariable regVar = this.ddmanager.getVariableForKey(ni_reg);
            switch (this.ddmanager.getVariableEffect(regVar, function)) {
                case DUAL: {
                    sign = Sign.dual;
                    break;
                }
                case POSITIVE: {
                    sign = Sign.positive;
                    break;
                }
                case NEGATIVE: {
                    sign = Sign.negative;
                }
            }
            in.setSign(sign);
        }
        FunctionTerm functionTerm = new FunctionTerm();
        functionTerm.setDefaultTerm(true);
        functionTerm.setResultLevel(0);
        tr.addFunctionTerm(functionTerm);
        ASTNode[] orNodes = new ASTNode[ni.getMax() + 1];
        int[] path = this.searcher.setNode(function);
        int[] tmax = this.searcher.getMax();
        ni_reg = this.searcher.iterator();
        while (ni_reg.hasNext()) {
            ASTNode orNode;
            int leaf = (Integer)ni_reg.next();
            if (leaf == 0) continue;
            ASTNode andNode = new ASTNode(ASTNode.Type.LOGICAL_AND);
            for (int i = 0; i < path.length; ++i) {
                ASTNode constraintNode;
                int cst = path[i];
                if (cst < 0) continue;
                int max = tmax[i];
                if (max >= 0 && max < cst) {
                    System.err.println("############## wrong max?");
                    continue;
                }
                if (max == cst) {
                    constraintNode = new ASTNode(ASTNode.Type.RELATIONAL_EQ);
                    constraintNode.addChild(new ASTNode(this.coreIDS[i]));
                    constraintNode.addChild(new ASTNode(cst));
                    andNode.addChild(constraintNode);
                    continue;
                }
                if (cst > 0) {
                    constraintNode = new ASTNode(ASTNode.Type.RELATIONAL_GEQ);
                    constraintNode.addChild(new ASTNode(this.coreIDS[i]));
                    constraintNode.addChild(new ASTNode(cst));
                    andNode.addChild(constraintNode);
                }
                if (max <= 0) continue;
                constraintNode = new ASTNode(ASTNode.Type.RELATIONAL_LEQ);
                constraintNode.addChild(new ASTNode(this.coreIDS[i]));
                constraintNode.addChild(new ASTNode(max));
                andNode.addChild(constraintNode);
            }
            if (andNode.getChildCount() == 1) {
                andNode = andNode.getChild(0);
            }
            if ((orNode = orNodes[leaf]) == null) {
                orNodes[leaf] = andNode;
                continue;
            }
            if (orNode.getType() != ASTNode.Type.LOGICAL_OR) {
                ASTNode oldOrNode = orNode;
                orNode = new ASTNode(ASTNode.Type.LOGICAL_OR);
                orNode.addChild(oldOrNode);
                orNodes[leaf] = orNode;
            }
            orNode.addChild(andNode);
        }
        for (int level = 1; level < orNodes.length; ++level) {
            ASTNode math = orNodes[level];
            if (math == null) continue;
            FunctionTerm ft = new FunctionTerm();
            ft.setResultLevel(level);
            ft.setMath(math);
            tr.addFunctionTerm(ft);
        }
    }
}

