/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.sbml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.ModelLayout;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.sbml.SBMLQualBundle;
import org.colomoto.biolqm.io.sbml.SBMLqualHelper;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDOperator;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.operators.MDDBaseOperators;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.GeneralGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.qual.FunctionTerm;
import org.sbml.jsbml.ext.qual.Input;
import org.sbml.jsbml.ext.qual.Output;
import org.sbml.jsbml.ext.qual.OutputTransitionEffect;
import org.sbml.jsbml.ext.qual.QualitativeSpecies;
import org.sbml.jsbml.ext.qual.Transition;

public class SBMLqualImport
extends BaseLoader {
    private SBMLQualBundle qualBundle = null;
    private Map<String, Integer> identifier2index;
    private MDDVariable[] ddvariables;
    private Map<String, Input> m_curInputs = new HashMap<String, Input>();

    public SBMLQualBundle getQualBundle() {
        return this.qualBundle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogicalModel performTask() throws IOException {
        ListOf layouts;
        try {
            this.qualBundle = SBMLqualHelper.parseInputStream(this.streams.input());
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        if (this.qualBundle == null) {
            return null;
        }
        this.identifier2index = new HashMap<String, Integer>();
        List<NodeInfo> variables = this.getVariables();
        MDDVariableFactory mvf = new MDDVariableFactory();
        for (NodeInfo nodeInfo : variables) {
            mvf.add((Object)nodeInfo, (byte)(nodeInfo.getMax() + 1));
        }
        MDDManager ddmanager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)10);
        this.ddvariables = ddmanager.getAllVariables();
        int[] functions = new int[variables.size()];
        for (Object tr : this.qualBundle.qmodel.getListOfTransitions()) {
            Object ft32;
            Object input22;
            this.m_curInputs.clear();
            ListOf inputs = tr.getListOfInputs();
            for (Object input22 : inputs) {
                String inputID = input22.getId();
                if (inputID == null) continue;
                this.m_curInputs.put(inputID, (Input)input22);
            }
            int defaultValue = 0;
            input22 = tr.getListOfFunctionTerms().iterator();
            while (input22.hasNext()) {
                FunctionTerm ft2 = (FunctionTerm)input22.next();
                if (!ft2.isDefaultTerm()) continue;
                defaultValue = ft2.getResultLevel();
                break;
            }
            int mdd = defaultValue;
            for (Object ft32 : tr.getListOfFunctionTerms()) {
                ASTNode math;
                int value = ft32.getResultLevel();
                if (value == defaultValue || (math = ft32.getMath()) == null) continue;
                int f = this.getMDDForMathML(ddmanager, ft32.getMath(), value);
                mdd = MDDBaseOperators.OR.combine(ddmanager, mdd, f);
            }
            ListOf outputs = tr.getListOfOutputs();
            ft32 = outputs.iterator();
            while (ft32.hasNext()) {
                Output output = (Output)ft32.next();
                OutputTransitionEffect effect = output.getTransitionEffect();
                if (effect != OutputTransitionEffect.assignmentLevel) {
                    throw new RuntimeException("Only handles assignement functions");
                }
                String name = output.getQualitativeSpecies();
                int idx = this.getIndexForName(name);
                NodeInfo ni = variables.get(idx);
                if (ni.isInput()) {
                    throw new RuntimeException("Constants can not be used as transition output");
                }
                functions[idx] = mdd;
            }
        }
        boolean bl = false;
        for (NodeInfo ni : variables) {
            void var5_8;
            if (ni.isInput()) {
                MDDVariable var = ddmanager.getVariableForKey((Object)ni);
                byte max = ni.getMax();
                if (max == 1) {
                    functions[var5_8] = var.getNode(0, 1);
                } else {
                    int[] values = new int[max + 1];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = i;
                    }
                    functions[var5_8] = var.getNode(values);
                }
            }
            ++var5_8;
        }
        LogicalModelImpl model = new LogicalModelImpl(variables, ddmanager, functions);
        if (this.qualBundle.lmodel != null && (layouts = this.qualBundle.lmodel.getListOfLayouts()) != null && layouts.size() > 0) {
            ModelLayout llayout = model.getLayout();
            Layout layout = (Layout)layouts.get(0);
            for (GraphicalObject graphics : layout.getListOfAdditionalGraphicalObjects()) {
                BoundingBox bb;
                GeneralGlyph glyph;
                String sid;
                NodeInfo ni;
                if (!(graphics instanceof GeneralGlyph) || (ni = model.getComponent(sid = (glyph = (GeneralGlyph)graphics).getReference())) == null || !glyph.isSetBoundingBox() || !(bb = glyph.getBoundingBox()).isSetPosition()) continue;
                Point pos = bb.getPosition();
                ModelLayout.LayoutInfo li = llayout.setPosition(ni, (int)pos.getX(), (int)pos.getY());
                if (!bb.isSetDimensions()) continue;
                Dimensions dim = bb.getDimensions();
                li.width = (int)dim.getWidth();
                li.height = (int)dim.getHeight();
            }
        }
        return model;
    }

    private List<NodeInfo> getVariables() {
        ArrayList<NodeInfo> variables = new ArrayList<NodeInfo>();
        int curIndex = 0;
        for (QualitativeSpecies sp : this.qualBundle.qmodel.getListOfQualitativeSpecies()) {
            String spid = sp.getId();
            if (spid.startsWith("s_")) {
                spid = spid.substring(2);
            }
            String name = sp.isSetName() ? sp.getName() : null;
            byte max = sp.isSetMaxLevel() ? (byte)sp.getMaxLevel() : (byte)-1;
            NodeInfo ni = new NodeInfo(spid, name, max);
            if (sp.isSetConstant() && sp.getConstant()) {
                ni.setInput(true);
            }
            variables.add(ni);
            this.identifier2index.put(sp.getId(), curIndex);
            ++curIndex;
        }
        this.guessMaxs(variables);
        return variables;
    }

    private void guessMaxs(List<NodeInfo> variables) {
        boolean[] needMax = new boolean[variables.size()];
        byte[] maxs = new byte[needMax.length];
        boolean allDefined = true;
        int i = 0;
        for (NodeInfo ni : variables) {
            byte max;
            maxs[i] = max = ni.getMax();
            if (max < 0) {
                needMax[i] = true;
                maxs[i] = 1;
                allDefined = false;
            } else {
                needMax[i] = false;
            }
            ++i;
        }
        if (allDefined) {
            return;
        }
        for (Transition tr : this.qualBundle.qmodel.getListOfTransitions()) {
            for (Output output : tr.getListOfOutputs()) {
                OutputTransitionEffect effect;
                String name = output.getQualitativeSpecies();
                int idx = this.getIndexForName(name);
                if (!needMax[idx] || (effect = output.getTransitionEffect()) != OutputTransitionEffect.assignmentLevel) continue;
                int max = maxs[idx];
                for (FunctionTerm ft : tr.getListOfFunctionTerms()) {
                    int value = ft.getResultLevel();
                    if (value <= max) continue;
                    max = value;
                }
                maxs[idx] = (byte)max;
            }
        }
        i = 0;
        for (NodeInfo ni : variables) {
            if (needMax[i]) {
                ni.setMax(maxs[i]);
            }
            ++i;
        }
    }

    public int getIndexForName(String name) {
        Integer index = this.identifier2index.get(name);
        if (index == null) {
            throw new RuntimeException("Could not find ID: " + name);
        }
        return index;
    }

    private int getMDDForMathML(MDDManager ddmanager, ASTNode math, int value) {
        ASTNode.Type type = math.getType();
        switch (type) {
            case NAME: {
                String name = math.getName().trim();
                int threshold = 1;
                Input input = this.m_curInputs.get(name);
                if (input != null) {
                    name = input.getQualitativeSpecies().trim();
                    threshold = input.getThresholdLevel();
                }
                if (threshold < 1) {
                    return value;
                }
                int index = this.getIndexForName(name);
                MDDVariable var = this.ddvariables[index];
                if (threshold >= var.nbval) {
                    throw new RuntimeException("Invalid threshold in " + input);
                }
                if (var.nbval == 2) {
                    return var.getNode(0, value);
                }
                int[] children = new int[var.nbval];
                for (int i = threshold; i < var.nbval; ++i) {
                    children[i] = value;
                }
                return var.getNode(children);
            }
            case RELATIONAL_GEQ: 
            case RELATIONAL_GT: 
            case RELATIONAL_LEQ: 
            case RELATIONAL_LT: 
            case RELATIONAL_NEQ: 
            case RELATIONAL_EQ: {
                return this.getMDDForRelation(math, value);
            }
            case CONSTANT_FALSE: {
                return 0;
            }
            case CONSTANT_TRUE: {
                return value;
            }
            case LOGICAL_NOT: {
                if (math.getChildCount() != 1) {
                    throw new RuntimeException("Invalid number of children in relation: " + math);
                }
                ASTNode child = math.getChild(0);
                int mdd = this.getMDDForMathML(ddmanager, child, value);
                return ddmanager.not(mdd);
            }
        }
        MDDOperator op = null;
        switch (type) {
            case LOGICAL_AND: {
                op = MDDBaseOperators.AND;
                break;
            }
            case LOGICAL_OR: {
                op = MDDBaseOperators.OR;
                break;
            }
            default: {
                throw new RuntimeException("TODO: support MathML node for: " + math);
            }
        }
        List children = math.getChildren();
        int childCount = children.size();
        int[] childrenFunctions = new int[childCount];
        int i = 0;
        for (ASTNode child : children) {
            childrenFunctions[i] = this.getMDDForMathML(ddmanager, child, value);
            ++i;
        }
        switch (childCount) {
            case 0: {
                throw new RuntimeException("Logical operation without children");
            }
            case 1: {
                return childrenFunctions[0];
            }
            case 2: {
                return op.combine(ddmanager, childrenFunctions[0], childrenFunctions[1]);
            }
        }
        return op.combine(ddmanager, childrenFunctions);
    }

    private int getMDDForRelation(ASTNode relation, int value) {
        int index;
        ASTNode.Type type = relation.getType();
        switch (type) {
            case RELATIONAL_GEQ: 
            case RELATIONAL_GT: 
            case RELATIONAL_LEQ: 
            case RELATIONAL_LT: 
            case RELATIONAL_NEQ: 
            case RELATIONAL_EQ: {
                break;
            }
            default: {
                throw new RuntimeException("Not a relation: " + relation);
            }
        }
        if (relation.getChildCount() != 2) {
            throw new RuntimeException("Invalid number of children in relation: " + relation);
        }
        ASTNode varNode = relation.getChild(0);
        ASTNode valueNode = relation.getChild(1);
        String varName = varNode.getName().trim();
        Integer relValue = null;
        boolean reversed = false;
        if (varNode.getType() == ASTNode.Type.NAME && valueNode.getType() == ASTNode.Type.INTEGER) {
            relValue = valueNode.getInteger();
        } else if (varNode.getType() == ASTNode.Type.INTEGER && valueNode.getType() == ASTNode.Type.NAME) {
            reversed = true;
            varName = valueNode.getName().trim();
            relValue = varNode.getInteger();
        } else if (varNode.getType() == ASTNode.Type.NAME && valueNode.getType() == ASTNode.Type.NAME) {
            String valueName = valueNode.getName().trim();
            Input input = this.m_curInputs.get(valueName);
            if (input == null && (input = this.m_curInputs.get(varName)) != null) {
                reversed = true;
                String stmp = varName;
                varName = valueName;
                valueName = stmp;
            }
            if (input != null) {
                if (!varName.equals(input.getQualitativeSpecies().trim())) {
                    throw new RuntimeException("Constraint '" + input.getQualitativeSpecies().trim() + "' and variable '" + varName + "' do not match in: " + relation);
                }
                try {
                    relValue = input.getThresholdLevel();
                }
                catch (Exception e) {
                    relValue = 1;
                }
            }
        }
        if (relValue == null) {
            throw new RuntimeException("Could not find a value in: " + relation);
        }
        if (reversed) {
            switch (type) {
                case RELATIONAL_GEQ: {
                    type = ASTNode.Type.RELATIONAL_LEQ;
                    break;
                }
                case RELATIONAL_LEQ: {
                    type = ASTNode.Type.RELATIONAL_GEQ;
                    break;
                }
                case RELATIONAL_GT: {
                    type = ASTNode.Type.RELATIONAL_LT;
                    break;
                }
                case RELATIONAL_LT: {
                    type = ASTNode.Type.RELATIONAL_GT;
                }
            }
        }
        if ((index = this.getIndexForName(varName)) < 0) {
            throw new RuntimeException("Unrecognized name in relation: " + relation);
        }
        MDDVariable var = this.ddvariables[index];
        switch (type) {
            case RELATIONAL_GT: {
                type = ASTNode.Type.RELATIONAL_GEQ;
                relValue = relValue + 1;
            }
            case RELATIONAL_GEQ: {
                if (relValue <= 0) {
                    return value;
                }
                if (relValue < var.nbval) break;
                return 0;
            }
            case RELATIONAL_LEQ: {
                type = ASTNode.Type.RELATIONAL_LT;
                relValue = relValue + 1;
            }
            case RELATIONAL_LT: {
                if (relValue >= var.nbval) {
                    return value;
                }
                if (relValue > 0) break;
                return 0;
            }
            case RELATIONAL_NEQ: {
                if (relValue >= 0 && relValue < var.nbval) break;
                return value;
            }
            case RELATIONAL_EQ: {
                if (relValue >= 0 && relValue < var.nbval) break;
                return 0;
            }
            default: {
                throw new RuntimeException("unknown relation type: " + relation);
            }
        }
        if (0 > relValue || var.nbval <= relValue) {
            throw new RuntimeException("Relation value out of [0.." + var.nbval + "[ range: " + valueNode);
        }
        if (var.nbval == 2) {
            switch (type) {
                case RELATIONAL_LT: {
                    return var.getNode(value, 0);
                }
                case RELATIONAL_GEQ: {
                    return var.getNode(0, value);
                }
                case RELATIONAL_EQ: {
                    if (relValue == 0) {
                        return var.getNode(value, 0);
                    }
                    return var.getNode(0, value);
                }
                case RELATIONAL_NEQ: {
                    if (relValue == 0) {
                        return var.getNode(0, value);
                    }
                    return var.getNode(value, 0);
                }
            }
            throw new RuntimeException("Could not handle relation: " + relation);
        }
        int[] values = new int[var.nbval];
        switch (type) {
            case RELATIONAL_GEQ: {
                for (int v = relValue.intValue(); v < var.nbval; ++v) {
                    values[v] = value;
                }
                return var.getNode(values);
            }
            case RELATIONAL_LT: {
                for (int v = 0; v < relValue; ++v) {
                    values[v] = value;
                }
                return var.getNode(values);
            }
            case RELATIONAL_NEQ: {
                for (int v = 0; v < var.nbval; ++v) {
                    values[v] = v == relValue ? 0 : value;
                }
                return var.getNode(values);
            }
            case RELATIONAL_EQ: {
                values[relValue.intValue()] = value;
                return var.getNode(values);
            }
        }
        throw new RuntimeException("Could not handle relation: " + relation);
    }

    private String mathml2string(ASTNode math, int value) {
        StringBuffer sb = new StringBuffer();
        this.mathml2string(math, sb);
        return sb.toString();
    }

    private void mathml2string(ASTNode math, StringBuffer sb) {
        ASTNode.Type type = math.getType();
        switch (type) {
            case NAME: {
                String name = math.getName().trim();
                int threshold = 1;
                Input input = this.m_curInputs.get(name);
                if (input != null) {
                    name = input.getQualitativeSpecies().trim();
                    threshold = input.getThresholdLevel();
                }
                if (threshold < 1) {
                    throw new RuntimeException("Inconsistent formula");
                }
                int index = this.getIndexForName(name);
                MDDVariable var = this.ddvariables[index];
                if (threshold >= var.nbval) {
                    throw new RuntimeException("Invalid threshold in " + input);
                }
                sb.append(var);
                if (threshold > 1) {
                    sb.append(var + ":" + threshold);
                }
                return;
            }
            case RELATIONAL_GEQ: 
            case RELATIONAL_GT: 
            case RELATIONAL_LEQ: 
            case RELATIONAL_LT: 
            case RELATIONAL_NEQ: 
            case RELATIONAL_EQ: {
                this.fillRelationString(math, sb);
                return;
            }
            case CONSTANT_FALSE: {
                sb.append("false");
                return;
            }
            case CONSTANT_TRUE: {
                sb.append("true");
                return;
            }
            case LOGICAL_NOT: {
                if (math.getChildCount() != 1) {
                    throw new RuntimeException("Invalid number of children in relation: " + math);
                }
                ASTNode child = math.getChild(0);
                switch (child.getType()) {
                    case CONSTANT_FALSE: {
                        sb.append("true");
                        return;
                    }
                    case CONSTANT_TRUE: {
                        sb.append("false");
                        return;
                    }
                    case LOGICAL_NOT: {
                        if (child.getChildCount() != 1) {
                            throw new RuntimeException("Invalid number of children in relation: " + math);
                        }
                        this.mathml2string(child.getChild(0), sb);
                        return;
                    }
                    case NAME: {
                        sb.append("!");
                        this.mathml2string(child, sb);
                        return;
                    }
                }
                sb.append("!(");
                this.mathml2string(child, sb);
                sb.append(")");
                return;
            }
        }
        String op = null;
        switch (type) {
            case LOGICAL_AND: {
                op = " & ";
                break;
            }
            case LOGICAL_OR: {
                op = " | ";
                break;
            }
            default: {
                throw new RuntimeException("TODO: support MathML node for: " + math);
            }
        }
        List children = math.getChildren();
        boolean first = true;
        for (ASTNode child : children) {
            this.mathml2string(child, sb);
            if (first) continue;
            first = false;
            sb.append(op);
        }
    }

    private void fillRelationString(ASTNode relation, StringBuffer sb) {
        int index;
        ASTNode.Type type = relation.getType();
        switch (type) {
            case RELATIONAL_GEQ: 
            case RELATIONAL_GT: 
            case RELATIONAL_LEQ: 
            case RELATIONAL_LT: 
            case RELATIONAL_NEQ: 
            case RELATIONAL_EQ: {
                break;
            }
            default: {
                throw new RuntimeException("Not a relation: " + relation);
            }
        }
        if (relation.getChildCount() != 2) {
            throw new RuntimeException("Invalid number of children in relation: " + relation);
        }
        ASTNode varNode = relation.getChild(0);
        ASTNode valueNode = relation.getChild(1);
        String varName = varNode.getName().trim();
        Integer relValue = null;
        boolean reversed = false;
        if (varNode.getType() == ASTNode.Type.NAME && valueNode.getType() == ASTNode.Type.INTEGER) {
            relValue = valueNode.getInteger();
        } else if (varNode.getType() == ASTNode.Type.INTEGER && valueNode.getType() == ASTNode.Type.NAME) {
            reversed = true;
            varName = valueNode.getName().trim();
            relValue = varNode.getInteger();
        } else if (varNode.getType() == ASTNode.Type.NAME && valueNode.getType() == ASTNode.Type.NAME) {
            String valueName = valueNode.getName().trim();
            Input input = this.m_curInputs.get(valueName);
            if (input == null && (input = this.m_curInputs.get(varName)) != null) {
                reversed = true;
                String stmp = varName;
                varName = valueName;
                valueName = stmp;
            }
            if (input != null) {
                if (!varName.equals(input.getQualitativeSpecies().trim())) {
                    throw new RuntimeException("Constraint '" + input.getQualitativeSpecies().trim() + "' and variable '" + varName + "' do not match in: " + relation);
                }
                try {
                    relValue = input.getThresholdLevel();
                }
                catch (Exception e) {
                    relValue = 1;
                }
            }
        }
        if (relValue == null) {
            throw new RuntimeException("Could not find a value in: " + relation);
        }
        if (reversed) {
            switch (type) {
                case RELATIONAL_GEQ: {
                    type = ASTNode.Type.RELATIONAL_LEQ;
                    break;
                }
                case RELATIONAL_LEQ: {
                    type = ASTNode.Type.RELATIONAL_GEQ;
                    break;
                }
                case RELATIONAL_GT: {
                    type = ASTNode.Type.RELATIONAL_LT;
                    break;
                }
                case RELATIONAL_LT: {
                    type = ASTNode.Type.RELATIONAL_GT;
                }
            }
        }
        if ((index = this.getIndexForName(varName)) < 0) {
            throw new RuntimeException("Unrecognized name in relation: " + relation);
        }
        MDDVariable var = this.ddvariables[index];
        switch (type) {
            case RELATIONAL_GT: {
                type = ASTNode.Type.RELATIONAL_GEQ;
                relValue = relValue + 1;
            }
            case RELATIONAL_GEQ: {
                if (relValue <= 0) {
                    sb.append("true");
                    return;
                }
                if (relValue < var.nbval) break;
                sb.append("false");
                return;
            }
            case RELATIONAL_LEQ: {
                type = ASTNode.Type.RELATIONAL_LT;
                relValue = relValue + 1;
            }
            case RELATIONAL_LT: {
                if (relValue >= var.nbval) {
                    sb.append("true");
                    return;
                }
                if (relValue > 0) break;
                sb.append("false");
                return;
            }
            case RELATIONAL_NEQ: {
                if (relValue >= 0 && relValue < var.nbval) break;
                sb.append("true");
                return;
            }
            case RELATIONAL_EQ: {
                if (relValue >= 0 && relValue < var.nbval) break;
                sb.append("false");
                return;
            }
            default: {
                throw new RuntimeException("unknown relation type: " + relation);
            }
        }
        if (0 > relValue || var.nbval <= relValue) {
            throw new RuntimeException("Relation value out of [0.." + var.nbval + "[ range: " + valueNode);
        }
        if (var.nbval == 2) {
            switch (type) {
                case RELATIONAL_LT: {
                    sb.append("!" + var);
                    return;
                }
                case RELATIONAL_GEQ: {
                    sb.append(var);
                    return;
                }
                case RELATIONAL_EQ: {
                    if (relValue == 0) {
                        sb.append("!" + var);
                        return;
                    }
                    sb.append(var);
                    return;
                }
                case RELATIONAL_NEQ: {
                    if (relValue == 0) {
                        sb.append(var);
                        return;
                    }
                    sb.append("!" + var);
                    return;
                }
            }
            throw new RuntimeException("Could not handle relation: " + relation);
        }
        throw new RuntimeException("Multi-valued is not handled here!");
    }
}

