/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.truthtable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.StreamProvider;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class TruthTableImport
extends BaseLoader {
    private final String SEPARATOR = "\\s+";

    private String getNextValidLine(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null && ((line = line.trim()).startsWith("#") || line.isEmpty())) {
        }
        return line;
    }

    private boolean isHeader(String line) {
        return line.matches(".*[a-zA-Z].*");
    }

    private List<NodeInfo> getNodes(StreamProvider streams) throws IOException {
        InputStreamReader fr = new InputStreamReader(streams.input());
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> nodeNames = new ArrayList<String>();
        String line = this.getNextValidLine(br);
        String[] saLine = line.split("\\s+");
        if (!this.isHeader(line)) {
            for (int i = 0; i < saLine[0].length(); ++i) {
                nodeNames.add("G" + i);
            }
        } else {
            for (String id : saLine) {
                nodeNames.add(id);
            }
            line = this.getNextValidLine(br);
        }
        int nLines = 1;
        saLine = line.split("\\s+");
        int iN = saLine[0].length();
        byte[] bMax = new byte[iN];
        do {
            for (int i = 0; i < iN; ++i) {
                byte val = (byte)Character.getNumericValue(saLine[0].charAt(i));
                if (bMax[i] >= val) continue;
                bMax[i] = val;
            }
            line = this.getNextValidLine(br);
            if (line == null || line.isEmpty()) continue;
            ++nLines;
            saLine = line.split("\\s+");
        } while (line != null);
        int totalLines = 1;
        for (int i = 0; i < bMax.length; ++i) {
            totalLines *= bMax[i] + 1;
        }
        if (nLines < totalLines) {
            System.err.println("TruthTable incomplete: found " + nLines + " (" + totalLines + " expected).\nMissing target states assumed to go towards null state.");
        }
        ArrayList<NodeInfo> nodeOrder = new ArrayList<NodeInfo>();
        for (int i = 0; i < bMax.length; ++i) {
            nodeOrder.add(new NodeInfo((String)nodeNames.get(i), bMax[i]));
        }
        br.close();
        ((Reader)fr).close();
        return nodeOrder;
    }

    @Override
    public LogicalModel performTask() throws IOException {
        String line;
        List<NodeInfo> nodeOrder = this.getNodes(this.streams);
        byte max = 0;
        MDDVariableFactory mvf = new MDDVariableFactory();
        for (NodeInfo node : nodeOrder) {
            mvf.add((Object)node, (byte)(node.getMax() + 1));
            if (node.getMax() <= max) continue;
            max = node.getMax();
        }
        MDDManager ddmanager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)(max + 1));
        InputStreamReader reader = new InputStreamReader(this.streams.input());
        BufferedReader br = new BufferedReader(reader);
        int[] kMDDs = new int[nodeOrder.size()];
        while ((line = this.getNextValidLine(br)) != null) {
            if (this.isHeader(line)) continue;
            String[] saLine = line.split("\\s+");
            int[] state = new int[nodeOrder.size()];
            for (int j = 0; j < nodeOrder.size(); ++j) {
                state[j] = Character.getNumericValue(saLine[0].charAt(j));
            }
            for (int i = 0; i < nodeOrder.size(); ++i) {
                int leaf = Character.getNumericValue(saLine[1].charAt(i));
                if (leaf <= 0) continue;
                int pathMDD = this.buildPathMDD(ddmanager, state, leaf);
                kMDDs[i] = MDDBaseOperators.OR.combine(ddmanager, kMDDs[i], pathMDD);
            }
        }
        br.close();
        ((Reader)reader).close();
        return new LogicalModelImpl(nodeOrder, ddmanager, kMDDs);
    }

    private int buildPathMDD(MDDManager ddmanager, int[] state, int leaf) {
        MDDVariable[] ddVariables = ddmanager.getAllVariables();
        int mddPath = leaf;
        for (int i = ddVariables.length - 1; i >= 0; --i) {
            int[] children = new int[ddVariables[i].nbval];
            children[state[i]] = mddPath;
            mddPath = ddVariables[i].getNode(children);
        }
        return mddPath;
    }
}

