/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.booleanize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.internal.MDDStoreImpl;
import org.colomoto.mddlib.operators.MDDBaseOperators;

public class BooleanizeModifier
extends BaseModifier {
    private final LogicalModel model;
    private MDDManager ddm;
    private MDDManager newDDM;
    private List<NodeInfo> core;
    private List<NodeInfo> extra;
    private List<NodeInfo> newCore;
    private List<NodeInfo> newExtra;
    private int[] coreFunctions;
    private int[] extraFunctions;
    private int[] newCoreFunctions;
    private int[] newExtraFunctions;
    private final Map<String, NodeInfo[]> mv2bool = new HashMap<String, NodeInfo[]>();

    public BooleanizeModifier(LogicalModel model) {
        this.model = model;
    }

    @Override
    public LogicalModel performTask() {
        if (this.model.isBoolean()) {
            return this.model;
        }
        this.ddm = this.model.getMDDManager();
        this.core = this.model.getComponents();
        this.extra = this.model.getExtraComponents();
        this.coreFunctions = this.model.getLogicalFunctions();
        this.extraFunctions = this.model.getExtraLogicalFunctions();
        this.newCore = this.getBoolComponents(this.core);
        this.newExtra = this.getBoolComponents(this.extra);
        List<Object> variables = this.getBoolVariables(this.ddm);
        this.newDDM = new MDDStoreImpl(variables, this.ddm.getLeafCount());
        this.newCoreFunctions = new int[this.newCore.size()];
        this.newExtraFunctions = new int[this.newExtra.size()];
        this.transformFunctions(this.core, this.coreFunctions, this.newCoreFunctions, false);
        this.transformFunctions(this.extra, this.extraFunctions, this.newExtraFunctions, true);
        return new LogicalModelImpl(this.newDDM, this.newCore, this.newCoreFunctions, this.newExtra, this.newExtraFunctions);
    }

    private List<Object> getBoolVariables(MDDManager ddm) {
        MDDVariable[] variables = ddm.getAllVariables();
        ArrayList<Object> boolVariables = new ArrayList<Object>();
        for (MDDVariable var : variables) {
            NodeInfo[] mapped;
            if (var.nbval < 3) {
                boolVariables.add(var.key);
                continue;
            }
            for (NodeInfo ni : mapped = this.getMapped(var.key.toString(), var.nbval)) {
                boolVariables.add(ni);
            }
        }
        return boolVariables;
    }

    private NodeInfo[] getMapped(String key, int nbval) {
        if (nbval < 3) {
            return null;
        }
        NodeInfo[] mapped = this.mv2bool.get(key);
        if (mapped != null) {
            return mapped;
        }
        mapped = new NodeInfo[nbval - 1];
        this.mv2bool.put(key, mapped);
        for (int v = 1; v < nbval; ++v) {
            mapped[v - 1] = new NodeInfo(key + "_b" + v);
        }
        for (NodeInfo ni : mapped) {
            ni.setBooleanizedGroup(mapped);
        }
        return mapped;
    }

    private List<NodeInfo> getBoolComponents(List<NodeInfo> nodes) {
        ArrayList<NodeInfo> newComponents = new ArrayList<NodeInfo>();
        for (NodeInfo ni : nodes) {
            byte max = ni.getMax();
            if (max > 1) {
                NodeInfo[] mapped;
                String name = ni.getNodeID();
                for (NodeInfo bnode : mapped = this.getMapped(name, max + 1)) {
                    newComponents.add(bnode);
                }
                continue;
            }
            newComponents.add(ni);
        }
        return newComponents;
    }

    private void transformFunctions(List<NodeInfo> nodes, int[] srcFunctions, int[] targetFunctions, boolean focalOnly) {
        int s = 0;
        int t = 0;
        for (NodeInfo ni : nodes) {
            NodeInfo[] bnodes = this.mv2bool.get(ni.getNodeID());
            int f = srcFunctions[s++];
            if (bnodes == null) {
                targetFunctions[t++] = this.transform(f, 1);
                continue;
            }
            for (int i = 0; i < bnodes.length; ++i) {
                int bf = this.transform(f, i + 1);
                if (!focalOnly) {
                    bf = BooleanizeModifier.restrictFunction(this.newDDM, bnodes, bf, i);
                }
                targetFunctions[t++] = bf;
            }
        }
    }

    private static int restrictFunction(MDDManager newDDM, NodeInfo[] bnodes, int bf, int i) {
        int tmp;
        if (i < bnodes.length - 1) {
            MDDVariable nextVar = newDDM.getVariableForKey((Object)bnodes[i + 1]);
            MDDVariable curVar = newDDM.getVariableForKey((Object)bnodes[i]);
            int next = nextVar.getNode(0, 1);
            int cur = curVar.getNode(0, 1);
            tmp = MDDBaseOperators.AND.combine(newDDM, cur, next);
            newDDM.free(cur);
            newDDM.free(next);
            cur = bf;
            bf = MDDBaseOperators.OR.combine(newDDM, bf, tmp);
            newDDM.free(cur);
            newDDM.free(tmp);
        }
        int restriction = 1;
        for (int j = 0; j < i; ++j) {
            MDDVariable prevVar = newDDM.getVariableForKey((Object)bnodes[j]);
            int prev = prevVar.getNode(0, 1);
            tmp = restriction;
            restriction = MDDBaseOperators.AND.combine(newDDM, restriction, prev);
            newDDM.free(prev);
            newDDM.free(tmp);
        }
        if (restriction != 1) {
            int tmp2 = bf;
            bf = MDDBaseOperators.AND.combine(newDDM, bf, restriction);
            newDDM.free(restriction);
            newDDM.free(tmp2);
        }
        return bf;
    }

    public static void preventForbiddenStates(MDDManager newDDM, List<NodeInfo> components, int[] functions) {
        int idx = 0;
        for (NodeInfo ni : components) {
            int bf;
            int i;
            NodeInfo[] bnodes = ni.getBooleanizedGroup();
            if (bnodes == null) {
                ++idx;
                continue;
            }
            for (i = 0; i < bnodes.length && bnodes[i] != ni; ++i) {
            }
            functions[idx] = bf = BooleanizeModifier.restrictFunction(newDDM, bnodes, functions[idx], i);
            ++idx;
        }
    }

    public int transform(int f, int v) {
        if (this.ddm.isleaf(f)) {
            if (f >= v) {
                return 1;
            }
            return 0;
        }
        MDDVariable var = this.ddm.getNodeVariable(f);
        if (var.nbval == 2) {
            MDDVariable newVar = this.newDDM.getVariableForKey(var.key);
            if (newVar == null) {
                throw new RuntimeException("No matching variable during Boolean conversion");
            }
            int c0 = this.transform(this.ddm.getChild(f, 0), v);
            int c1 = this.transform(this.ddm.getChild(f, 1), v);
            return newVar.getNodeFree(c0, c1);
        }
        NodeInfo[] newVars = this.mv2bool.get(var.key.toString());
        if (newVars == null) {
            throw new RuntimeException("No mapped bool vars found");
        }
        int[] values = this.ddm.getChildren(f);
        int[] newValues = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = this.transform(values[i], v);
        }
        int cur = newValues[newValues.length - 1];
        for (int i = newVars.length - 1; i >= 0; --i) {
            int prev = newValues[i];
            MDDVariable bvar = this.newDDM.getVariableForKey((Object)newVars[i]);
            cur = bvar.getNodeFree(prev, cur);
        }
        return cur;
    }
}

