/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.buffer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BufferingRule {
    private int count = 0;
    private int startPosition = -1;
    private final int sourceIndex;
    private Map<Integer, Integer> data = new HashMap<Integer, Integer>();

    BufferingRule(int sourceIndex) {
        this.sourceIndex = sourceIndex;
    }

    public void add(List<Integer> targets) {
        if (this.startPosition >= 0) {
            throw new RuntimeException("Buffering setup is locked");
        }
        for (int t : targets) {
            this.data.put(t, this.count);
        }
        ++this.count;
    }

    public void add(int target) {
        if (this.startPosition >= 0) {
            throw new RuntimeException("Buffering setup is locked");
        }
        this.data.put(target, this.count);
        ++this.count;
    }

    public int get(int target) {
        if (this.startPosition < 0) {
            throw new RuntimeException("Buffering setup must be locked first");
        }
        Integer result = this.data.get(target);
        if (result != null) {
            return this.startPosition + result;
        }
        return this.sourceIndex;
    }

    public int count() {
        return this.count;
    }

    public void lock(int startPosition) {
        this.startPosition = startPosition;
    }
}

