/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import java.util.ArrayList;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.biolqm.modifier.perturbation.FixedValuePerturbation;
import org.colomoto.biolqm.modifier.perturbation.InteractionPerturbation;
import org.colomoto.biolqm.modifier.perturbation.LogicalModelPerturbation;
import org.colomoto.biolqm.modifier.perturbation.MultiplePerturbation;
import org.colomoto.biolqm.modifier.perturbation.RangePerturbation;

public class PerturbationModifier
extends BaseModifier {
    private final LogicalModel model;
    private LogicalModelPerturbation perturbation;

    public PerturbationModifier(LogicalModel model) {
        this.model = model;
    }

    @Override
    public LogicalModel performTask() {
        if (this.perturbation != null) {
            return this.perturbation.apply(this.model);
        }
        return this.model;
    }

    @Override
    public void setParameters(String[] parameters) {
        if (parameters.length == 1) {
            this.perturbation = PerturbationModifier.getSimplePerturbationFromString(this.model, parameters[0]);
        }
        ArrayList<LogicalModelPerturbation> perturbations = new ArrayList<LogicalModelPerturbation>();
        for (String s : parameters) {
            LogicalModelPerturbation p = PerturbationModifier.getSimplePerturbationFromString(this.model, s);
            if (p == null) continue;
            perturbations.add(p);
        }
        if (perturbations.size() < 1) {
            this.perturbation = null;
        }
        if (perturbations.size() == 1) {
            this.perturbation = (LogicalModelPerturbation)perturbations.get(0);
        }
        this.perturbation = new MultiplePerturbation(perturbations);
    }

    private static LogicalModelPerturbation getSimplePerturbationFromString(LogicalModel model, String parameters) {
        String[] params = parameters.split("%");
        if (params.length != 2) {
            return null;
        }
        String s_source = null;
        String s_target = params[0];
        int idx = s_target.indexOf(58);
        if (idx >= 0) {
            s_source = s_target.substring(0, idx);
            s_target = s_target.substring(idx + 1);
        }
        NodeInfo source = model.getComponent(s_source);
        NodeInfo target = model.getComponent(s_target);
        String restriction = params[1];
        idx = restriction.indexOf(58);
        int min = -1;
        int max = -1;
        if (idx >= 0) {
            min = Integer.parseInt(restriction.substring(0, idx));
            max = Integer.parseInt(restriction.substring(idx + 1));
        } else {
            max = min = Integer.parseInt(restriction);
        }
        if (max < min) {
            min = max;
        }
        if (source == null) {
            if (min == max) {
                return new FixedValuePerturbation(target, min);
            }
            return new RangePerturbation(target, min, max);
        }
        if (min == max) {
            return new InteractionPerturbation(source, target, min);
        }
        return null;
    }
}

