/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.perturbation.LogicalModelPerturbation;
import org.colomoto.biolqm.modifier.perturbation.RangeRestrictionOperation;

public class RangePerturbation
implements LogicalModelPerturbation {
    public final int min;
    public final int max;
    public final NodeInfo component;

    public RangePerturbation(NodeInfo target, int min, int max) {
        if (min < 0 || max < min || max > target.getMax()) {
            throw new RuntimeException("Invalid perturbation range for " + target + ": " + min + "," + max);
        }
        this.component = target;
        this.min = min;
        this.max = max;
    }

    @Override
    public void restrictValues(byte[] state, List<NodeInfo> nodeOrder) {
        int index = nodeOrder.indexOf(this.component);
        if (state[index] < this.min) {
            state[index] = (byte)this.min;
        } else if (state[index] > this.max) {
            state[index] = (byte)this.max;
        }
    }

    @Override
    public void update(LogicalModel model) {
        int idx = -1;
        int[] functions = null;
        idx = model.getComponents().indexOf(this.component);
        if (idx >= 0) {
            functions = model.getLogicalFunctions();
        } else {
            idx = model.getExtraComponents().indexOf(this.component);
            if (idx >= 0) {
                functions = model.getExtraLogicalFunctions();
            }
        }
        if (idx < 0) {
            throw new RuntimeException("Perturbation.update(): Could not find the target component");
        }
        if (this.min == 0 && this.max == this.component.getMax()) {
            return;
        }
        int oldValue = functions[idx];
        if (this.min == this.max) {
            functions[idx] = this.min;
        } else {
            RangeRestrictionOperation op = new RangeRestrictionOperation(model.getMDDManager(), this.min, this.max);
            functions[idx] = op.restrict(oldValue);
        }
        model.getMDDManager().free(oldValue);
    }

    public String toString() {
        return this.component.getNodeID() + " [" + this.min + "," + this.max + "]";
    }

    @Override
    public String getStringRepresentation() {
        return this.component.getNodeID() + "%" + this.min + ":" + this.max;
    }

    public boolean equals(Object o) {
        if (o instanceof RangePerturbation) {
            RangePerturbation p = (RangePerturbation)o;
            return p.min == this.min && p.max == this.max && p.component.equals(this.component);
        }
        return false;
    }

    @Override
    public boolean affectsNode(NodeInfo node) {
        return this.component.equals(node);
    }
}

