/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class RegulatorRemovalOperation {
    private final MDDManager manager;
    private final MDDVariable regulator;
    private final int value;

    public RegulatorRemovalOperation(MDDManager manager, MDDVariable regulator, int value) {
        this.manager = manager;
        this.regulator = regulator;
        this.value = value;
    }

    public int restrict(int node) {
        if (this.manager.isleaf(node)) {
            return node;
        }
        MDDVariable var = this.manager.getNodeVariable(node);
        if (var.after(this.regulator)) {
            this.manager.use(node);
            return node;
        }
        if (var == this.regulator) {
            int n = this.manager.getChild(node, this.value);
            this.manager.use(n);
            return n;
        }
        if (var.nbval == 2) {
            int f = this.restrict(this.manager.getChild(node, 0));
            int t = this.restrict(this.manager.getChild(node, 1));
            return var.getNodeFree(f, t);
        }
        int[] children = new int[var.nbval];
        for (int i = 0; i < var.nbval; ++i) {
            children[i] = this.restrict(this.manager.getChild(node, i));
        }
        return var.getNodeFree(children);
    }
}

